/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jwebbox;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;

public class JspBox {
    public static final String JSPBOXID = "JSPBOX";
    private String name;
    private String prepareStaticMethod;
    private Object prepareBean;
    private String prepareBeanMethod;
    private String prepareURL;
    private String text;
    private Object page;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private JspBox fatherJspBox;
    private PageContext pageContext;

    public JspBox() {
    }

    public JspBox(String page) {
        this.setPage(page);
    }

    public static boolean isEmptyStr(String str) {
        return str == null || str.length() == 0;
    }

    public void beforeExecute() {
    }

    public void execute() {
    }

    public void afterExecute() {
    }

    public void afterPrepared() {
    }

    public void render() {
    }

    public void afterShow() {
    }

    public JspBox show(PageContext pageContext) {
        try {
            this.pageContext = pageContext;
            this.beforeExecute();
            this.execute();
            this.afterExecute();
            this.prepareOnly(pageContext);
            this.afterPrepared();
            this.showText(pageContext);
            this.render();
            JspBox.showPageOrUrl(pageContext, this.page, this);
            this.afterShow();
        }
        finally {
            this.pageContext = null;
        }
        return this;
    }

    private JspBox showText(PageContext pageContext) {
        if (this.text != null && this.text.length() > 0) {
            try {
                pageContext.getOut().write(this.text);
            }
            catch (IOException e) {
                throw new JspBoxException(e);
            }
        }
        return this;
    }

    public void prepareOnly(PageContext pageContext) {
        if (!JspBox.isEmptyStr(this.prepareStaticMethod)) {
            int index = this.prepareStaticMethod.lastIndexOf(46);
            String className = this.prepareStaticMethod.substring(0, index);
            String methodName = this.prepareStaticMethod.substring(index + 1, this.prepareStaticMethod.length());
            if (JspBox.isEmptyStr(className) || JspBox.isEmptyStr(methodName)) {
                throw new JspBoxException("Error#001: Can not call method: " + this.prepareStaticMethod);
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, PageContext.class, JspBox.class);
                m.invoke(c, pageContext, this);
            }
            catch (Exception e) {
                throw new JspBoxException(e);
            }
        }
        if (this.prepareBean != null) {
            this.executeBeanMethod(pageContext);
        }
        JspBox.showPageOrUrl(pageContext, this.prepareURL, this);
    }

    private void executeBeanMethod(PageContext pageContext) {
        try {
            Class<?> c = this.prepareBean.getClass();
            String methodName = JspBox.isEmptyStr(this.prepareBeanMethod) ? "prepare" : this.prepareBeanMethod;
            Method m = c.getMethod(methodName, PageContext.class, JspBox.class);
            m.invoke(this.prepareBean, pageContext, this);
        }
        catch (Exception e) {
            throw new JspBoxException(e);
        }
    }

    public JspBox showPageOnly(PageContext pageContext) {
        return JspBox.showPageOrUrl(pageContext, this.page, this);
    }

    private static JspBox showPageOrUrl(PageContext pageContext, Object page, JspBox currentBox) {
        if (page == null) {
            return currentBox;
        }
        if (page instanceof JspBox) {
            ((JspBox)page).show(pageContext);
            return currentBox;
        }
        if (!(page instanceof String)) {
            throw new JspBoxException("" + page + " is not a String or JspBox.");
        }
        String pageOrUrl = (String)page;
        if (JspBox.isEmptyStr(pageOrUrl)) {
            return currentBox;
        }
        JspBox fatherJspBox = (JspBox)pageContext.getRequest().getAttribute(JSPBOXID);
        if (fatherJspBox != null) {
            currentBox.setFatherJspBox(fatherJspBox);
        }
        pageContext.getRequest().setAttribute(JSPBOXID, (Object)currentBox);
        try {
            pageContext.getOut().flush();
            pageContext.getRequest().getRequestDispatcher(pageOrUrl).include(pageContext.getRequest(), pageContext.getResponse());
            pageContext.getOut().flush();
        }
        catch (Exception e) {
            throw new JspBoxException(e);
        }
        finally {
            pageContext.getRequest().setAttribute(JSPBOXID, (Object)fatherJspBox);
            currentBox.setFatherJspBox(null);
        }
        return currentBox;
    }

    public static JspBox getBox(PageContext pageContext) {
        JspBox currentBox = (JspBox)pageContext.getRequest().getAttribute(JSPBOXID);
        if (currentBox == null) {
            throw new JspBoxException("Error#003: Can not find JspBox instance in pageContext");
        }
        return currentBox;
    }

    public static <T> T getAttribute(PageContext pageContext, String attributeName) {
        T obj = JspBox.getBox(pageContext).getAttribute(attributeName);
        return obj;
    }

    public static void showAttribute(PageContext pageContext, String attributeName) {
        Object obj = JspBox.getAttribute(pageContext, attributeName);
        JspBox.showTarget(pageContext, obj);
    }

    public static void showTarget(PageContext pageContext, Object target) {
        if (target == null) {
            return;
        }
        if (target instanceof JspBox) {
            ((JspBox)target).show(pageContext);
        } else if (target instanceof ArrayList) {
            for (Object item : (ArrayList)target) {
                JspBox.showTarget(pageContext, item);
            }
        } else if (target instanceof Class) {
            JspBox bx = null;
            try {
                bx = (JspBox)((Class)target).newInstance();
            }
            catch (Exception e) {
                throw new JspBoxException("Can not create JspBox instance for target class '" + target + "'", e);
            }
            bx.show(pageContext);
        } else if (target instanceof String) {
            String str = (String)target;
            if (str.startsWith("/")) {
                JspBox.showPageOrUrl(pageContext, str, JspBox.getBox(pageContext));
            } else {
                try {
                    pageContext.getOut().write(str);
                }
                catch (IOException e) {
                    throw new JspBoxException(e);
                }
            }
        } else {
            throw new JspBoxException("Can not show unknow type object " + target + " on page");
        }
    }

    public JspBox setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public <T> T getAttribute(String key) {
        Object obj = this.attributeMap.get(key);
        if (obj == null && this.pageContext != null) {
            obj = this.pageContext.getRequest().getAttribute(key);
            if (obj == null) {
                obj = this.pageContext.getRequest().getParameter(key);
            }
            if (obj == null) {
                obj = this.pageContext.getAttribute(key);
            }
        }
        return (T)obj;
    }

    public <T> T getObject(String key) {
        if (this.pageContext == null || key == null) {
            return null;
        }
        Object obj = this.pageContext.getAttribute(key);
        if (obj == null) {
            obj = this.pageContext.getRequest().getAttribute(key);
        }
        if (obj == null) {
            obj = this.pageContext.getRequest().getParameter(key);
        }
        if (obj == null) {
            obj = this.pageContext.getSession().getAttribute(key);
        }
        return (T)obj;
    }

    public void setPageContextAttribute(String key, Object value) {
        this.pageContext.setAttribute(key, value);
    }

    public void setRequestAttribute(String key, Object value) {
        this.pageContext.getRequest().setAttribute(key, value);
    }

    public void setSessionAttribute(String key, Object value) {
        this.pageContext.getSession().setAttribute(key, value);
    }

    public String getPrepareURL() {
        return this.prepareURL;
    }

    public JspBox setPrepareURL(String prepareURL) {
        this.prepareURL = prepareURL;
        return this;
    }

    public Object getPage() {
        return this.page;
    }

    public JspBox setPage(Object page) {
        if (page != null && !(page instanceof String) && !(page instanceof JspBox)) {
            throw new JspBoxException("setPage method only accept String or JspBox instance type parameter");
        }
        this.page = page;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public JspBox setText(String text) {
        this.text = text;
        return this;
    }

    public JspBox setPrepareStaticMethod(String prepareStaticMethod) {
        this.prepareStaticMethod = prepareStaticMethod;
        return this;
    }

    public String getPrepareStaticMethod() {
        return this.prepareStaticMethod;
    }

    public Object getPrepareBean() {
        return this.prepareBean;
    }

    public JspBox setPrepareBean(Object prepareBean) {
        this.prepareBean = prepareBean;
        return this;
    }

    public String getPrepareBeanMethod() {
        return this.prepareBeanMethod;
    }

    public JspBox setPrepareBeanMethod(String prepareBeanMethod) {
        this.prepareBeanMethod = prepareBeanMethod;
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public JspBox setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public JspBox setName(String name) {
        this.name = name;
        return this;
    }

    public JspBox getFatherJspBox() {
        return this.fatherJspBox;
    }

    public void setFatherJspBox(JspBox fatherJspBox) {
        this.fatherJspBox = fatherJspBox;
    }

    public PageContext getPageContext() {
        return this.pageContext;
    }

    public void setPageContext(PageContext pageContext) {
        this.pageContext = pageContext;
    }

    public static class Show
    extends SimpleTagSupport {
        private String attribute;
        private Object target;

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public Object getTarget() {
            return this.target;
        }

        public void setTarget(Object target) {
            this.target = target;
        }

        public void doTag() throws JspException, IOException {
            if (this.attribute != null && this.attribute.length() != 0) {
                JspBox.showAttribute((PageContext)this.getJspContext(), this.getAttribute());
            }
            if (this.target != null) {
                JspBox.showTarget((PageContext)this.getJspContext(), this.target);
            }
        }
    }

    public static class JspBoxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public JspBoxException(String msg) {
            super(msg);
        }

        public JspBoxException(Throwable e) {
            super(e);
        }

        public JspBoxException(String msg, Throwable e) {
            super(msg, e);
        }
    }
}

