/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jwebbox;

import com.github.drinkjava2.jwebbox.WebBoxStrUtils;
import com.github.drinkjava2.jwebbox.render.HtmlRender;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebBox {
    private static String webappFolder = HtmlRender.class.getClassLoader().getResource("").getPath();
    public static final String JWEBBOXID = "WEBBOX";
    private String name;
    private String prepareStaticMethod;
    private Object prepareBean;
    private String prepareBeanMethod;
    private String prepareURL;
    private String text;
    private Object page;
    private Map<String, Object> attributeMap = new HashMap<String, Object>();
    private WebBox fatherWebBox;
    private HttpServletRequest request;
    private HttpServletResponse response;

    public static String getWebappFolder() {
        return webappFolder;
    }

    public static void setWebappFolder(String webappFolder) {
        WebBox.webappFolder = webappFolder;
    }

    public WebBox() {
    }

    public WebBox(String page) {
        this.setPage(page);
    }

    public static boolean isEmptyStr(String str) {
        return str == null || str.length() == 0;
    }

    public void beforeExecute() {
    }

    public void execute() {
    }

    public void afterExecute() {
    }

    public void afterPrepared() {
    }

    public void afterShow() {
    }

    public WebBox show(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.request = request;
            this.response = response;
            this.beforeExecute();
            this.execute();
            this.afterExecute();
            this.prepareOnly(request, response);
            this.afterPrepared();
            this.showText(request, response);
            WebBox.showPageOrUrl(request, response, this.page, this);
            this.afterShow();
        }
        finally {
            this.request = null;
            this.response = null;
        }
        return this;
    }

    private WebBox showText(HttpServletRequest request, HttpServletResponse response) {
        if (this.text != null && this.text.length() > 0) {
            try {
                response.getWriter().write(this.text);
            }
            catch (IOException e) {
                throw new WebBoxException(e);
            }
        }
        return this;
    }

    public void prepareOnly(HttpServletRequest request, HttpServletResponse response) {
        if (!WebBox.isEmptyStr(this.prepareStaticMethod)) {
            int index = this.prepareStaticMethod.lastIndexOf(46);
            String className = this.prepareStaticMethod.substring(0, index);
            String methodName = this.prepareStaticMethod.substring(index + 1, this.prepareStaticMethod.length());
            if (WebBox.isEmptyStr(className) || WebBox.isEmptyStr(methodName)) {
                throw new WebBoxException("Error#001: Can not call method: " + this.prepareStaticMethod);
            }
            try {
                Class<?> c = Class.forName(className);
                Method m = c.getMethod(methodName, HttpServletRequest.class, HttpServletResponse.class, WebBox.class);
                m.invoke(c, request, response, this);
            }
            catch (Exception e) {
                throw new WebBoxException(e);
            }
        }
        if (this.prepareBean != null) {
            this.executeBeanMethod(request, response);
        }
        WebBox.showPageOrUrl(request, response, this.prepareURL, this);
    }

    private void executeBeanMethod(HttpServletRequest request, HttpServletResponse response) {
        try {
            Class<?> c = this.prepareBean.getClass();
            String methodName = WebBox.isEmptyStr(this.prepareBeanMethod) ? "prepare" : this.prepareBeanMethod;
            Method m = c.getMethod(methodName, HttpServletRequest.class, HttpServletResponse.class, WebBox.class);
            m.invoke(this.prepareBean, request, response, this);
        }
        catch (Exception e) {
            throw new WebBoxException(e);
        }
    }

    public WebBox showPageOnly(HttpServletRequest request, HttpServletResponse response) {
        return WebBox.showPageOrUrl(request, response, this.page, this);
    }

    public void render(HttpServletRequest request, HttpServletResponse response, String pageOrUrl) throws Exception {
        HtmlRender.renderAsHtml(request, response, pageOrUrl);
    }

    private static WebBox showPageOrUrl(HttpServletRequest request, HttpServletResponse response, Object page, WebBox currentBox) {
        if (page == null) {
            return currentBox;
        }
        if (page instanceof WebBox) {
            ((WebBox)page).show(request, response);
            return currentBox;
        }
        if (!(page instanceof String)) {
            throw new WebBoxException("" + page + " is not a String or HtmlBox.");
        }
        String pageOrUrl = (String)page;
        if (WebBox.isEmptyStr(pageOrUrl)) {
            return currentBox;
        }
        WebBox fatherHtmlBox = (WebBox)request.getAttribute(JWEBBOXID);
        if (fatherHtmlBox != null) {
            currentBox.setFatherHtmlBox(fatherHtmlBox);
        }
        request.setAttribute(JWEBBOXID, (Object)currentBox);
        try {
            if (response != null && response.getWriter() != null) {
                response.getWriter().flush();
            }
            currentBox.render(request, response, pageOrUrl);
            if (response != null && response.getWriter() != null) {
                response.getWriter().flush();
            }
        }
        catch (Exception e) {
            throw new WebBoxException(e);
        }
        finally {
            request.setAttribute(JWEBBOXID, (Object)fatherHtmlBox);
            currentBox.setFatherHtmlBox(null);
        }
        return currentBox;
    }

    public static WebBox getBox(HttpServletRequest request) {
        WebBox currentBox = (WebBox)request.getAttribute(JWEBBOXID);
        if (currentBox == null) {
            throw new WebBoxException("Error#003: Can not find HtmlBox instance in pageContext");
        }
        return currentBox;
    }

    public static <T> T getAttribute(HttpServletRequest request, HttpServletResponse response, String attributeName) {
        return WebBox.getBox(request).getAttribute(attributeName);
    }

    public static void showAttribute(HttpServletRequest request, HttpServletResponse response, String attributeName) {
        Object obj = WebBox.getAttribute(request, response, attributeName);
        WebBox.showTarget(request, response, obj);
    }

    public static void showTarget(HttpServletRequest request, HttpServletResponse response, Object target) {
        if (target == null) {
            return;
        }
        if (target instanceof WebBox) {
            ((WebBox)target).show(request, response);
        } else if (target instanceof ArrayList) {
            for (Object item : (ArrayList)target) {
                WebBox.showTarget(request, response, item);
            }
        } else if (target instanceof Class) {
            WebBox bx = null;
            try {
                bx = (WebBox)((Class)target).newInstance();
            }
            catch (Exception e) {
                throw new WebBoxException("Can not create HtmlBox instance for target class '" + target + "'", e);
            }
            bx.show(request, response);
        } else if (target instanceof String) {
            String str = (String)target;
            if (str.startsWith("/")) {
                WebBox.showPageOrUrl(request, response, str, WebBox.getBox(request));
            } else {
                try {
                    response.getWriter().write(str);
                }
                catch (IOException e) {
                    throw new WebBoxException(e);
                }
            }
        } else {
            throw new WebBoxException("Can not show unknow type object " + target + " on page");
        }
    }

    public WebBox setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
        return this;
    }

    public <T> T getAttribute(String key) {
        Object obj = this.attributeMap.get(key);
        if (obj == null && this.request != null) {
            obj = this.request.getAttribute(key);
            if (obj == null) {
                obj = this.request.getParameter(key);
            }
            if (obj == null) {
                obj = this.request.getAttribute(key);
            }
        }
        return (T)obj;
    }

    public <T> T getObject(String key) {
        if (this.request == null || key == null) {
            return null;
        }
        Object obj = this.request.getAttribute(key);
        if (obj == null) {
            obj = this.request.getAttribute(key);
        }
        if (obj == null) {
            obj = this.request.getParameter(key);
        }
        if (obj == null) {
            obj = this.request.getSession().getAttribute(key);
        }
        return (T)obj;
    }

    public void setRequestAttribute(String key, Object value) {
        this.request.setAttribute(key, value);
    }

    public void setSessionAttribute(String key, Object value) {
        this.request.getSession().setAttribute(key, value);
    }

    public String getPrepareURL() {
        return this.prepareURL;
    }

    public WebBox setPrepareURL(String prepareURL) {
        this.prepareURL = prepareURL;
        return this;
    }

    public Object getPage() {
        return this.page;
    }

    public WebBox setPage(Object page) {
        if (page != null && !(page instanceof String) && !(page instanceof WebBox)) {
            throw new WebBoxException("setPage method only accept String or HtmlBox instance type parameter");
        }
        this.page = page;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public WebBox setText(String text) {
        this.text = text;
        return this;
    }

    public WebBox setPrepareStaticMethod(String prepareStaticMethod) {
        this.prepareStaticMethod = prepareStaticMethod;
        return this;
    }

    public String getPrepareStaticMethod() {
        return this.prepareStaticMethod;
    }

    public Object getPrepareBean() {
        return this.prepareBean;
    }

    public WebBox setPrepareBean(Object prepareBean) {
        this.prepareBean = prepareBean;
        return this;
    }

    public String getPrepareBeanMethod() {
        return this.prepareBeanMethod;
    }

    public WebBox setPrepareBeanMethod(String prepareBeanMethod) {
        this.prepareBeanMethod = prepareBeanMethod;
        return this;
    }

    public Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    public WebBox setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public WebBox setName(String name) {
        this.name = name;
        return this;
    }

    public WebBox getFatherHtmlBox() {
        return this.fatherWebBox;
    }

    public void setFatherHtmlBox(WebBox fatherHtmlBox) {
        this.fatherWebBox = fatherHtmlBox;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    static {
        if (webappFolder != null) {
            webappFolder = webappFolder.contains("/WEB-INF") ? WebBoxStrUtils.substringBefore(webappFolder, "/WEB-INF") : WebBoxStrUtils.substringBefore(webappFolder, "/target/") + "/src/main/webapp";
        }
    }

    public static class WebBoxException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WebBoxException(String msg) {
            super(msg);
        }

        public WebBoxException(Throwable e) {
            super(e);
        }

        public WebBoxException(String msg, Throwable e) {
            super(msg, e);
        }

        public static void assureNotNull(Object obj, String ... optionMessages) {
            if (obj == null) {
                throw new WebBoxException(optionMessages.length == 0 ? "Assert error, Parameter can not be null" : optionMessages[0]);
            }
        }
    }
}

