/*
 * Decompiled with CFR 0.152.
 */
package com.github.drinkjava2.jwebbox.render;

import com.github.drinkjava2.jwebbox.WebBox;
import com.github.drinkjava2.jwebbox.WebBoxStrUtils;
import com.github.drinkjava2.jwebbox.render.HtmlItem;
import com.github.drinkjava2.jwebbox.render.HtmlItemType;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HtmlRender {
    private static final Map<String, HtmlItem[]> htmlCache = new ConcurrentHashMap<String, HtmlItem[]>();

    public static void renderAsHtml(HttpServletRequest request, HttpServletResponse response, String pageOrUrl) throws Exception {
        HtmlItem[] items = HtmlRender.getItemsFromPageOrUrl(pageOrUrl);
        if (items == null || items.length == 0) {
            throw new WebBox.WebBoxException("No pageOrUrl context found: " + pageOrUrl);
        }
        for (HtmlItem item : items) {
            if (HtmlItemType.TEXT == item.type) {
                response.getWriter().print((String)item.value);
                continue;
            }
            if (HtmlItemType.URL == item.type) {
                request.getRequestDispatcher((String)item.value).include((ServletRequest)request, (ServletResponse)response);
                continue;
            }
            if (HtmlItemType.BOX == item.type) {
                ((WebBox)item.value).show(request, response);
                continue;
            }
            if (HtmlItemType.BOX_ATTRIBUTE != item.type) continue;
            WebBox box = WebBox.getBox(request);
            Object attribute = box.getAttribute((String)item.value);
            if (attribute != null) {
                WebBox.showTarget(request, response, attribute);
                continue;
            }
            throw new WebBox.WebBoxException("Null pageOrUrl context found: '" + item.value + "' in " + pageOrUrl);
        }
    }

    private static HtmlItem[] getItemsFromPageOrUrl(String pageOrUrl) {
        if (WebBoxStrUtils.isEmpty(pageOrUrl)) {
            return new HtmlItem[0];
        }
        HtmlItem[] stored = htmlCache.get(pageOrUrl);
        if (stored != null) {
            return stored;
        }
        String text = WebBoxStrUtils.readFile(WebBox.getWebappFolder() + pageOrUrl, "utf-8");
        HtmlItem[] result = HtmlRender.splitToHtmlItems(text);
        htmlCache.put(pageOrUrl, result);
        return result;
    }

    private static HtmlItem[] splitToHtmlItems(String text) {
        if (WebBoxStrUtils.isEmpty(text)) {
            return new HtmlItem[0];
        }
        ArrayList<HtmlItem> resultList = new ArrayList<HtmlItem>();
        String[] ss = text.split("\\$\\$show\\(");
        if (ss != null && ss.length > 0) {
            resultList.add(new HtmlItem(ss[0], HtmlItemType.TEXT));
        }
        if (ss != null) {
            for (int i = 1; i < ss.length; ++i) {
                String st = ss[i];
                int pos = st.indexOf(41);
                if (pos > 0) {
                    String value = WebBoxStrUtils.substringBefore(st, ")");
                    String leftOver = WebBoxStrUtils.substringAfter(st, ")");
                    if (value.startsWith("/")) {
                        HtmlItem[] childHtmlItems;
                        String fileContext = WebBoxStrUtils.readFile(WebBox.getWebappFolder() + value, "utf-8");
                        for (HtmlItem childItem : childHtmlItems = HtmlRender.splitToHtmlItems(fileContext)) {
                            resultList.add(childItem);
                        }
                    } else if (WebBoxStrUtils.startsWithIgnoreCase(value, "URL:")) {
                        resultList.add(new HtmlItem(WebBoxStrUtils.substringAfter(value, ":"), HtmlItemType.URL));
                    } else if (WebBoxStrUtils.startsWithIgnoreCase(value, "BOX:")) {
                        String boxClaz = WebBoxStrUtils.substringAfter(value, ":");
                        try {
                            Class<?> clazz = Class.forName(boxClaz);
                            WebBox box = (WebBox)clazz.newInstance();
                            resultList.add(new HtmlItem(box, HtmlItemType.BOX));
                        }
                        catch (Exception e) {
                            throw new WebBox.WebBoxException(e);
                        }
                    } else {
                        resultList.add(new HtmlItem(value, HtmlItemType.BOX_ATTRIBUTE));
                    }
                    resultList.add(new HtmlItem(leftOver, HtmlItemType.TEXT));
                    continue;
                }
                resultList.add(new HtmlItem(st, HtmlItemType.TEXT));
            }
        }
        return resultList.toArray(new HtmlItem[resultList.size()]);
    }
}

