/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource;

import com.jn.langx.Named;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.exception.IllegalPropertyException;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.sqlhelper.datasource.DelegatingNamedDataSource;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.SmartDataSource;
import com.jn.sqlhelper.datasource.config.DataSourceProperties;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSources {
    private static final Logger logger = LoggerFactory.getLogger(DataSources.class);
    public static final String DATASOURCE_IMPLEMENT_KEY_TOMCAT = "tomcat";
    public static final String DATASOURCE_IMPLEMENT_KEY_HIKARICP = "hikaricp";
    public static final String DATASOURCE_IMPLEMENT_KEY_DRUID = "druid";
    public static final String DATASOURCE_IMPLEMENT_KEY_DBCP2 = "dbcp2";
    public static final String DATASOURCE_IMPLEMENT_KEY_C3P0 = "c3p0";
    public static final String DATASOURCE_PROP_IMPLEMENTATION = "datasource.implementation";
    public static final String DATASOURCE_PROP_GROUP = "datasource.group";
    public static final String DATASOURCE_PROP_NAME = "datasource.name";
    public static final String DATASOURCE_PRIMARY_GROUP = "primary";
    public static final String DATASOURCE_PRIMARY_NAME = "primary";
    public static final DataSourceKey DATASOURCE_PRIMARY = new DataSourceKey("primary", "primary");
    public static final String DATASOURCE_NAME_WILDCARD = "*";
    private static final String DATASOURCE_ID_SEPARATOR = "SQLHelper.DynamicDataSource.ID.separator";

    public static void releaseConnection(Connection con, DataSource dataSource) {
        try {
            DataSources.doReleaseConnection(con, dataSource);
        }
        catch (SQLException ex) {
            logger.debug("Could not close JDBC Connection", (Throwable)ex);
        }
        catch (Throwable ex) {
            logger.debug("Unexpected exception on closing JDBC Connection", ex);
        }
    }

    public static void doReleaseConnection(Connection con, DataSource dataSource) throws SQLException {
        if (con == null) {
            return;
        }
        DataSources.doCloseConnection(con, dataSource);
    }

    public static void doCloseConnection(Connection con, DataSource dataSource) throws SQLException {
        if (!(dataSource instanceof SmartDataSource) || ((SmartDataSource)dataSource).shouldClose(con)) {
            con.close();
        }
    }

    public static boolean isImplementationKeyMatched(@NonNull String expectedKey, DataSourceProperties properties) {
        Preconditions.checkNotNull((Object)expectedKey, (String)"the expected jdbc datasource implementation key is null or empty");
        String implementationKey = properties.getImplementation();
        boolean implementationKeyMatched = true;
        if (Emptys.isNotEmpty((Object)implementationKey) && !Objs.equals((Object)expectedKey, (Object)implementationKey)) {
            implementationKeyMatched = false;
        }
        return implementationKeyMatched;
    }

    public static String getDatasourceIdSeparator() {
        return System.getProperty(DATASOURCE_ID_SEPARATOR, "::");
    }

    public static NamedDataSource toNamedDataSource(DataSource dataSource) {
        if (dataSource instanceof NamedDataSource) {
            return (NamedDataSource)dataSource;
        }
        String name = null;
        if (dataSource instanceof Named) {
            name = ((Named)dataSource).getName();
        }
        if (Strings.isBlank(name)) {
            name = UUID.randomUUID().toString();
        }
        return DataSources.toNamedDataSource(dataSource, name, null);
    }

    public static NamedDataSource toNamedDataSource(@NonNull DataSource delegate, String name, DataSourceProperties dataSourceProperties) {
        return DataSources.toNamedDataSource(delegate, null, name, dataSourceProperties);
    }

    public static NamedDataSource toNamedDataSource(DataSource dataSource, DataSourceKey dataSourceKey, DataSourceProperties dataSourceProperties) {
        return DataSources.toNamedDataSource(dataSource, dataSourceKey.getGroup(), dataSourceKey.getName(), dataSourceProperties);
    }

    public static NamedDataSource toNamedDataSource(@NonNull DataSource delegate, @Nullable String group, @NonNull String name, DataSourceProperties dataSourceProperties) {
        Preconditions.checkNotNull((Object)delegate, (String)"the delegate is null");
        Preconditions.checkNotEmpty((Object)name, (String)"the name is null or empty");
        group = Strings.useValueIfBlank((String)group, (String)"primary");
        if (delegate instanceof NamedDataSource) {
            NamedDataSource namedDataSource = (NamedDataSource)delegate;
            namedDataSource.setGroup(group);
            namedDataSource.setName(name);
            return namedDataSource;
        }
        DelegatingNamedDataSource dataSource = new DelegatingNamedDataSource();
        dataSource.setDelegate(delegate);
        dataSource.setName(name);
        dataSource.setGroup(group);
        dataSource.setDataSourceProperties(dataSourceProperties);
        return dataSource;
    }

    public static DataSourceKey buildDataSourceKey(String idString) {
        String separator = DataSources.getDatasourceIdSeparator();
        if (!Strings.contains((CharSequence)idString, (CharSequence)separator)) {
            throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource id: {}", (Object[])new Object[]{"/"}));
        }
        int index = idString.indexOf(separator);
        if (index > 0) {
            String group = idString.substring(0, index);
            String name = idString.substring(index + separator.length());
            if (Emptys.isNoneEmpty((Object[])new Object[]{group, name})) {
                return new DataSourceKey(group, name);
            }
            throw new IllegalPropertyException("group or name is empty or null");
        }
        throw new IllegalPropertyException("group or name is empty or null");
    }
}

