/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.invocation.proxy.Proxys;
import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.datasource.DataSourceRegistry;
import com.jn.sqlhelper.datasource.DataSourceRegistryAware;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.MethodInvocationDataSourceKeySelector;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.sql.DataSource;

public class SimpleDynamicDataSourceInvocationHandler
implements InvocationHandler,
DataSourceRegistryAware {
    private DataSourceRegistry registry;

    @Override
    public void setDataSourceRegistry(DataSourceRegistry registry) {
        this.registry = registry;
    }

    private DataSource getDelegateDataSource() {
        return this.getDelegateDataSource(true);
    }

    private DataSource getDelegateDataSource(boolean throwIfNotFound) {
        DataSourceKey key = MethodInvocationDataSourceKeySelector.getCurrent();
        if (key == null) {
            key = this.registry.getPrimary();
        }
        if (throwIfNotFound) {
            Preconditions.checkNotNull((Object)key, (String)"the jdbc datasource key is null");
        }
        NamedDataSource dataSource = this.registry.get(key);
        if (throwIfNotFound) {
            Preconditions.checkNotNull((Object)dataSource, (String)"can't find a suitable jdbc datasource");
        }
        return dataSource;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        DataSource dataSource = this.getDelegateDataSource();
        return method.invoke((Object)dataSource, args);
    }

    public static DataSource newDynamicDataSource(@NonNull DataSourceRegistry registry) {
        SimpleDynamicDataSourceInvocationHandler handler = new SimpleDynamicDataSourceInvocationHandler();
        handler.setDataSourceRegistry(registry);
        return (DataSource)Proxys.newProxyInstance((InvocationHandler)handler, (Class[])new Class[]{DataSource.class});
    }
}

