/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.c3p0;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.text.StringTemplates;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.config.DataSourceProperties;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.factory.c3p0.C3p0DataSources;
import java.util.Properties;
import javax.sql.DataSource;

@Name(value="c3p0")
@OnClasses(value={"com.mchange.v2.c3p0.WrapperConnectionPoolDataSource"})
public class C3p0DataSourceFactory
implements DataSourceFactory {
    @Override
    public NamedDataSource get(DataSourceProperties dataSourceProperties) {
        if (DataSources.isImplementationKeyMatched("c3p0", dataSourceProperties)) {
            DataSource dataSource = C3p0DataSources.createDataSource(dataSourceProperties);
            String name = dataSourceProperties.getName();
            return DataSources.toNamedDataSource(dataSource, name, dataSourceProperties);
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource implementationKey {}, expected key is {}", (Object[])new Object[]{dataSourceProperties.getImplementation(), "c3p0"}));
    }

    @Override
    public NamedDataSource get(Properties properties) {
        DataSource dataSource = C3p0DataSources.createDataSource(properties);
        String name = properties.getProperty("datasource.name");
        DataSourceProperties dataSourceProperties = C3p0DataSources.toDataSourceProperties(properties);
        return DataSources.toNamedDataSource(dataSource, name, dataSourceProperties);
    }
}

