/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.dbcp2;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.text.StringTemplates;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.config.DataSourceProperties;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.factory.dbcp2.Dbcp2DataSources;
import java.util.Properties;
import javax.sql.DataSource;

@Name(value="dbcp2")
@OnClasses(value={"org.apache.commons.dbcp2.BasicDataSource", "org.apache.commons.dbcp2.BasicDataSourceFactory"})
public class Dbcp2DataSourceFactory
implements DataSourceFactory {
    @Override
    public NamedDataSource get(DataSourceProperties dataSourceProperties) {
        if (DataSources.isImplementationKeyMatched("dbcp2", dataSourceProperties)) {
            DataSource dataSource = Dbcp2DataSources.createDataSource(dataSourceProperties);
            String name = dataSourceProperties.getName();
            return DataSources.toNamedDataSource(dataSource, name, dataSourceProperties);
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource implementationKey {}, expected key is {}", (Object[])new Object[]{dataSourceProperties.getImplementation(), "dbcp2"}));
    }

    @Override
    public NamedDataSource get(Properties properties) {
        DataSource dataSource = Dbcp2DataSources.createDataSource(properties);
        String name = properties.getProperty("datasource.name");
        DataSourceProperties dataSourceProperties = Dbcp2DataSources.toDataSourceProperties(properties);
        return DataSources.toNamedDataSource(dataSource, name, dataSourceProperties);
    }
}

