/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.druid;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.OnClasses;
import com.jn.langx.text.StringTemplates;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.config.DataSourceProperties;
import com.jn.sqlhelper.datasource.factory.DataSourceFactory;
import com.jn.sqlhelper.datasource.factory.druid.AlibabaDruidDataSources;
import java.util.Properties;
import javax.sql.DataSource;

@Name(value="druid")
@OnClasses(value={"com.alibaba.druid.pool.DruidDataSource", "com.alibaba.druid.pool.DruidDataSourceFactory"})
public class AlibabaDruidDataSourceFactory
implements DataSourceFactory {
    @Override
    public NamedDataSource get(DataSourceProperties dataSourceProperties) {
        if (DataSources.isImplementationKeyMatched("druid", dataSourceProperties)) {
            DataSource dataSource = AlibabaDruidDataSources.createDataSource(dataSourceProperties);
            String name = dataSourceProperties.getName();
            return DataSources.toNamedDataSource(dataSource, name, dataSourceProperties);
        }
        throw new IllegalArgumentException(StringTemplates.formatWithPlaceholder((String)"Illegal datasource implementationKey {}, expected key is {}", (Object[])new Object[]{dataSourceProperties.getImplementation(), "druid"}));
    }

    @Override
    public NamedDataSource get(Properties properties) {
        DataSource dataSource = AlibabaDruidDataSources.createDataSource(properties);
        String name = properties.getProperty("datasource.name");
        DataSourceProperties dataSourceProperties = AlibabaDruidDataSources.toDataSourceProperties(properties);
        return DataSources.toNamedDataSource(dataSource, name, dataSourceProperties);
    }
}

