/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.factory.tomcatjdbc;

import com.jn.langx.util.Maths;
import com.jn.langx.util.Throwables;
import com.jn.sqlhelper.common.transaction.utils.Isolation;
import com.jn.sqlhelper.common.transaction.utils.Transactions;
import com.jn.sqlhelper.datasource.config.DataSourceProperties;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.tomcat.jdbc.pool.DataSourceFactory;

public class TomcatJdbcDataSources {
    private TomcatJdbcDataSources() {
    }

    public static DataSource createDataSource(DataSourceProperties properties) {
        String catalog;
        String driverClassName;
        String url;
        String password;
        String username;
        DataSourceFactory dsf = new DataSourceFactory();
        Properties props = properties.getDriverProps();
        if (props == null) {
            props = new Properties();
        }
        if ((username = properties.getUsername()) != null) {
            props.setProperty("username", username);
        }
        if ((password = properties.getPassword()) != null) {
            props.setProperty("password", password);
        }
        if ((url = properties.getUrl()) != null) {
            props.setProperty("url", url);
        }
        if ((driverClassName = properties.getDriverClassName()) != null) {
            props.setProperty("driverClassName", driverClassName);
        }
        props.setProperty("defaultAutoCommit", "" + properties.isAutoCommit());
        props.setProperty("defaultReadOnly", "" + properties.isReadonly());
        Isolation isolation = Transactions.getTransactionIsolation((String)properties.getTransactionIsolation());
        if (Transactions.isValidIsolation((Isolation)isolation)) {
            props.setProperty("defaultTransactionIsolation", isolation.getName());
        }
        if ((catalog = properties.getCatalog()) != null) {
            props.setProperty("defaultCatalog", catalog);
        }
        props.setProperty("initialSize", "" + properties.getInitialSize());
        props.setProperty("minIdle", "" + properties.getMinIdle());
        props.setProperty("maxIdle", "" + Maths.max((int[])new int[]{8, properties.getMinIdle()}));
        props.setProperty("maxActive", "" + Maths.max((int[])new int[]{8, properties.getMaxPoolSize()}));
        String validationQuery = properties.getValidationQuery();
        if (validationQuery != null) {
            props.setProperty("validationQuery", validationQuery);
        }
        try {
            return dsf.createDataSource(props);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    public static DataSource createDataSource(Properties properties) {
        try {
            DataSourceFactory dsf = new DataSourceFactory();
            return dsf.createDataSource(properties);
        }
        catch (Exception ex) {
            throw Throwables.wrapAsRuntimeException((Throwable)ex);
        }
    }

    public static DataSourceProperties toDataSourceProperties(Properties properties) {
        DataSourceProperties dataSourceProperties = new DataSourceProperties();
        dataSourceProperties.setDriverProps(properties);
        return dataSourceProperties;
    }
}

