/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.key;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.annotation.Singleton;
import com.jn.langx.cluster.loadbalance.LoadBalancer;
import com.jn.langx.invocation.MethodInvocation;
import com.jn.langx.invocation.matcher.MethodMatcher;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.stack.ListableStack;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.reflect.Reflects;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.ThreadLocalHolder;
import com.jn.sqlhelper.datasource.DataSourceRegistry;
import com.jn.sqlhelper.datasource.DataSourceRegistryAware;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.DataSourceKeySelector;
import com.jn.sqlhelper.datasource.key.MethodDataSourceKeyRegistry;
import com.jn.sqlhelper.datasource.key.WriteOperationMethodMatcher;
import com.jn.sqlhelper.datasource.key.router.DataSourceKeyRouter;
import com.jn.sqlhelper.datasource.key.router.RandomRouter;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MethodInvocationDataSourceKeySelector
implements DataSourceRegistryAware,
LoadBalancer<DataSourceKey, MethodInvocation>,
DataSourceKeySelector<MethodInvocation>,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(MethodInvocationDataSourceKeySelector.class);
    private static final ThreadLocalHolder<ListableStack<DataSourceKey>> DATA_SOURCE_KEY_HOLDER = new ThreadLocalHolder((Supplier0)new Supplier0<ListableStack<DataSourceKey>>(){

        public ListableStack<DataSourceKey> get() {
            return new ListableStack();
        }
    });
    private static final ThreadLocalHolder<DataSourceKey> CURRENT_SELECTED = new ThreadLocalHolder();
    @NonNull
    private MethodDataSourceKeyRegistry dataSourceKeyRegistry;
    @NonNull
    private DataSourceRegistry dataSourceRegistry;
    @NonNull
    private MethodMatcher defaultWriteOperationMatcher;
    @Nullable
    private DataSourceKeyRouter defaultRouter;
    private final ConcurrentHashMap<String, DataSourceKeyRouter> routerMap = new ConcurrentHashMap();
    private final Map<String, DataSourceKeyRouter> groupToRouterMap = new ConcurrentHashMap<String, DataSourceKeyRouter>();
    private final Map<String, MethodMatcher> groupToWriteMatcherMap = new ConcurrentHashMap<String, MethodMatcher>();

    public MethodInvocationDataSourceKeySelector() {
        RandomRouter r = new RandomRouter();
        r.setLoadBalancer(this);
        this.registerRouter(r, true);
    }

    public void init() throws InitializationException {
        Preconditions.checkNotNull((Object)this.dataSourceRegistry, (String)"the datasource registry is null");
        Preconditions.checkNotNull((Object)this.dataSourceKeyRegistry, (String)"the datasource key registry is null");
        if (this.defaultWriteOperationMatcher == null) {
            this.defaultWriteOperationMatcher = new WriteOperationMethodMatcher((String)null);
        }
    }

    @Override
    public void setDataSourceRegistry(DataSourceRegistry registry) {
        this.dataSourceRegistry = registry;
    }

    public MethodDataSourceKeyRegistry getDataSourceKeyRegistry() {
        return this.dataSourceKeyRegistry;
    }

    public void setDataSourceKeyRegistry(MethodDataSourceKeyRegistry dataSourceKeyRegistry) {
        this.dataSourceKeyRegistry = dataSourceKeyRegistry;
    }

    public void setDefaultRouter(DataSourceKeyRouter router) {
        this.defaultRouter = router;
    }

    public void registerRouter(DataSourceKeyRouter router) {
        this.registerRouter(router, false);
    }

    public void registerRouter(DataSourceKeyRouter router, boolean asDefault) {
        Preconditions.checkNotNull((Object)router);
        Preconditions.checkNotEmpty((Object)router.getName(), (String)"the router name is null or empty");
        this.routerMap.put(router.getName(), router);
        router.setLoadBalancer(this);
        if (asDefault) {
            this.setDefaultRouter(router);
        }
    }

    public void registerRouters(List<DataSourceKeyRouter> routers) {
        Collects.forEach(routers, (Consumer)new Consumer<DataSourceKeyRouter>(){

            public void accept(DataSourceKeyRouter router) {
                MethodInvocationDataSourceKeySelector.this.registerRouter(router);
            }
        });
    }

    public void allocateRouter(String group, String routerName) {
        DataSourceKeyRouter router = this.routerMap.get(routerName);
        if (router != null) {
            this.groupToRouterMap.put(group, router);
            return;
        }
        logger.warn("Can't find the router: {}", (Object)routerName);
    }

    public void allocateWriteMatcher(String group, MethodMatcher methodMatcher) {
        this.groupToWriteMatcherMap.put(group, methodMatcher);
    }

    public DataSourceKeyRouter getRouter(String group) {
        DataSourceKeyRouter router = this.groupToRouterMap.get(group);
        if (router == null) {
            router = this.defaultRouter;
        }
        if (router != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("use router {} for group {}", (Object)router.getName(), (Object)group);
            }
        } else {
            logger.warn("Can't find any available route for group {}", (Object)group);
        }
        return router;
    }

    public static void addChoice(DataSourceKey key) {
        Preconditions.checkNotNull((Object)key);
        ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
        stack.push((Object)key);
    }

    public static void removeChoice(@Nullable DataSourceKey key) {
        ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
        if (!stack.isEmpty()) {
            if (key != null) {
                if (key == stack.peek()) {
                    stack.pop();
                } else {
                    logger.warn("the datasource key {} will been removed is not equals the stack top :{}", (Object)key, stack.peek());
                }
            } else {
                stack.pop();
            }
        }
    }

    public static ListableStack<DataSourceKey> getChoices() {
        return (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
    }

    public static void clearChoices() {
        ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
        stack.clear();
    }

    public static void setCurrent(DataSourceKey key) {
        Preconditions.checkNotNull((Object)key);
        CURRENT_SELECTED.set((Object)key);
        MethodInvocationDataSourceKeySelector.addChoice(key);
    }

    public static DataSourceKey getCurrent() {
        return (DataSourceKey)CURRENT_SELECTED.get();
    }

    public static void removeCurrent() {
        DataSourceKey current = MethodInvocationDataSourceKeySelector.getCurrent();
        CURRENT_SELECTED.reset();
        MethodInvocationDataSourceKeySelector.removeChoice(current);
    }

    @Override
    public final DataSourceKey select(@Nullable MethodInvocation methodInvocation) {
        NamedDataSource dataSource;
        if (methodInvocation == null) {
            logger.debug("starting to select a datasource key");
        } else {
            logger.debug("starting to select a datasource key for invocation : {}", (Object)Reflects.getMethodString((Method)((Method)methodInvocation.getJoinPoint())));
        }
        DataSourceKey key = null;
        if (methodInvocation != null) {
            key = this.dataSourceKeyRegistry.get((Method)methodInvocation.getJoinPoint());
        }
        if (key != null && (dataSource = this.dataSourceRegistry.get(key)) != null) {
            MethodInvocationDataSourceKeySelector.setCurrent(key);
        }
        if ((key = MethodInvocationDataSourceKeySelector.getCurrent()) == null) {
            key = this.doSelect(methodInvocation);
        }
        if (key != null) {
            dataSource = this.dataSourceRegistry.get(key);
            if (dataSource == null) {
                logger.warn("Can't find a datasource named: {}", (Object)key);
            }
            if (methodInvocation != null) {
                logger.debug("select a datasource key {} for invocation : {}", (Object)key, (Object)Reflects.getMethodString((Method)((Method)methodInvocation.getJoinPoint())));
            } else {
                logger.debug("select a datasource key {} ", (Object)key);
            }
        }
        return key;
    }

    protected DataSourceKey doSelect(@Nullable MethodInvocation methodInvocation) {
        List keys;
        if (!CURRENT_SELECTED.isNull()) {
            return MethodInvocationDataSourceKeySelector.getCurrent();
        }
        Preconditions.checkArgument((this.dataSourceRegistry.size() > 0 ? 1 : 0) != 0, (String)"has no any datasource registered");
        if (this.dataSourceRegistry.size() == 1) {
            return this.dataSourceRegistry.getPrimary();
        }
        final Holder dataSourceKeyList = new Holder();
        final Holder isReadOperation = new Holder(null);
        if (methodInvocation != null) {
            isReadOperation.set((Object)(!this.defaultWriteOperationMatcher.matches(methodInvocation) ? 1 : 0));
            logger.debug("the operation {} is {}", (Object)Reflects.getMethodString((Method)((Method)methodInvocation.getJoinPoint())), (Object)((Boolean)isReadOperation.get() != false ? "read" : "write"));
        }
        if (dataSourceKeyList.isEmpty()) {
            ListableStack stack = (ListableStack)DATA_SOURCE_KEY_HOLDER.get();
            if (Emptys.isEmpty((Object)stack)) {
                List<DataSourceKey> matched = this.dataSourceRegistry.findKeys(this.dataSourceRegistry.getPrimary());
                if (Emptys.isNotEmpty(matched)) {
                    dataSourceKeyList.set(matched);
                }
            } else {
                Collects.forEach((Iterable)stack, (Predicate)new Predicate<DataSourceKey>(){

                    public boolean test(DataSourceKey dataSourceKey) {
                        return dataSourceKey != null;
                    }
                }, (Consumer)new Consumer<DataSourceKey>(){

                    public void accept(DataSourceKey dataSourceKey) {
                        List<DataSourceKey> matched = MethodInvocationDataSourceKeySelector.this.dataSourceRegistry.findKeys(dataSourceKey);
                        if (Emptys.isNotEmpty(matched)) {
                            dataSourceKeyList.set(matched);
                        }
                    }
                }, (Predicate)new Predicate<DataSourceKey>(){

                    public boolean test(DataSourceKey dataSourceKey) {
                        return !dataSourceKeyList.isEmpty();
                    }
                });
            }
        }
        if (!dataSourceKeyList.isEmpty()) {
            List operationMatchedKeys;
            keys = (List)dataSourceKeyList.get();
            if (!isReadOperation.isNull() && Emptys.isNotEmpty((Object)(operationMatchedKeys = Pipeline.of((Iterable)keys).filter((Predicate)new Predicate<DataSourceKey>(){

                public boolean test(DataSourceKey dataSourceKey) {
                    return MethodInvocationDataSourceKeySelector.this.dataSourceRegistry.get(dataSourceKey).isSlave() == ((Boolean)isReadOperation.get()).booleanValue();
                }
            }).asList()))) {
                dataSourceKeyList.set((Object)operationMatchedKeys);
                if (operationMatchedKeys.size() == 1) {
                    return (DataSourceKey)operationMatchedKeys.get(0);
                }
                if (!((Boolean)isReadOperation.get()).booleanValue()) {
                    return (DataSourceKey)operationMatchedKeys.get(0);
                }
            }
        }
        if (!dataSourceKeyList.isEmpty()) {
            keys = (List)dataSourceKeyList.get();
            Holder keyHolder = new Holder();
            DataSourceKeyRouter router = this.getRouter(((DataSourceKey)keys.get(0)).getGroup());
            if (router != null) {
                keyHolder.set((Object)router.select(keys, methodInvocation));
            }
            return (DataSourceKey)keyHolder.get();
        }
        return null;
    }

    public DataSourceRegistry getDataSourceRegistry() {
        return this.dataSourceRegistry;
    }

    public void addNode(DataSourceKey node) {
    }

    public void removeNode(DataSourceKey key) {
    }

    public boolean hasNode(DataSourceKey key) {
        return this.dataSourceRegistry.get(key) != null;
    }

    public void markDown(DataSourceKey key) {
    }

    public List<DataSourceKey> getNodes() {
        return this.dataSourceRegistry.allKeys();
    }

    public List<DataSourceKey> getNodes(Predicate<DataSourceKey> predicate) {
        return Pipeline.of(this.getNodes()).filter(predicate).asList();
    }

    public boolean isEmpty() {
        return this.dataSourceRegistry.size() == 0;
    }

    public void setDefaultWriteOperationMatcher(MethodMatcher defaultWriteOperationMatcher) {
        this.defaultWriteOperationMatcher = defaultWriteOperationMatcher;
    }
}

