/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.aop;

import com.jn.agileway.aop.adapter.aopalliance.MethodInvocationAdapter;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.common.transaction.TransactionDefinition;
import com.jn.sqlhelper.common.transaction.TransactionDefinitionRegistry;
import com.jn.sqlhelper.common.transaction.TransactionManager;
import com.jn.sqlhelper.common.transaction.utils.TransactionAops;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizeGlobalTransactionInterceptor
implements MethodInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(LocalizeGlobalTransactionInterceptor.class);
    private TransactionManager transactionManager;
    private TransactionDefinitionRegistry definitionRegistry;

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setDefinitionRegistry(TransactionDefinitionRegistry definitionRegistry) {
        this.definitionRegistry = definitionRegistry;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.transactionManager == null || this.definitionRegistry == null) {
            if (logger.isDebugEnabled()) {
                if (this.transactionManager == null) {
                    logger.debug("the transactionManager is null, so will do it not use any transaction manager, the method is: {}", (Object)Reflects.getMethodString((Method)invocation.getMethod()));
                }
                if (this.definitionRegistry == null) {
                    logger.debug("the transaction definition registry is null, so will do it not with a transaction manager, the method is: {}", (Object)Reflects.getMethodString((Method)invocation.getMethod()));
                }
            }
            return invocation.proceed();
        }
        TransactionDefinition definition = this.definitionRegistry.get(invocation.getMethod());
        if (definition == null) {
            if (logger.isDebugEnabled() && this.definitionRegistry == null) {
                logger.debug("can't find any transaction definition , so will do it not with a transaction manager, the method is: {}", (Object)Reflects.getMethodString((Method)invocation.getMethod()));
            }
            return invocation.proceed();
        }
        MethodInvocationAdapter adapter = new MethodInvocationAdapter(invocation);
        return TransactionAops.invoke((Logger)logger, (TransactionManager)this.transactionManager, (TransactionDefinition)definition, (com.jn.langx.invocation.MethodInvocation)adapter);
    }
}

