/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.langx.invocation.MethodInvocation;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.router.DataSourceWeighter;
import com.jn.sqlhelper.datasource.key.router.RandomRouter;
import com.jn.sqlhelper.datasource.key.router.RoundRobinRouter;
import com.jn.sqlhelper.datasource.spring.boot.DynamicDataSourcesAutoConfiguration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"sqlhelper.dynamic-datasource.enabled"}, havingValue="true", matchIfMissing=false)
@Configuration
@AutoConfigureAfter(value={DynamicDataSourcesAutoConfiguration.class})
public class DynamicDataSourceLoadBalanceAutoConfiguration {
    @Bean(name={"dataSourceRoundRobinWeighter"})
    @ConditionalOnMissingBean(name={"dataSourceRoundRobinWeighter"})
    public DataSourceWeighter dataSourceRoundRobinWeighter() {
        return new DataSourceWeighter(){

            @Override
            public int getWeight(DataSourceKey key, MethodInvocation methodInvocation) {
                return 0;
            }
        };
    }

    @Bean(name={"roundRobinRouter"})
    @ConditionalOnMissingBean(name={"roundRobinRouter"})
    public RoundRobinRouter roundRobinRouter(@Qualifier(value="dataSourceRoundRobinWeighter") DataSourceWeighter weighter) {
        RoundRobinRouter router = new RoundRobinRouter();
        router.setWeighter(weighter);
        return router;
    }

    @Bean(name={"dataSourceRandomWeighter"})
    @ConditionalOnMissingBean(name={"dataSourceRandomWeighter"})
    public DataSourceWeighter dataSourceRandomWeighter() {
        return new DataSourceWeighter(){

            @Override
            public int getWeight(DataSourceKey key, MethodInvocation methodInvocation) {
                return 0;
            }
        };
    }

    @Bean(value={"dataSourceRandomRouter"})
    @ConditionalOnMissingBean(name={"dataSourceRandomRouter"})
    public RandomRouter dataSourceRandomRouter(@Qualifier(value="dataSourceRandomWeighter") DataSourceWeighter weighter) {
        RandomRouter router = new RandomRouter();
        router.setWeighter(weighter);
        return router;
    }
}

