/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.langx.util.ClassLoaders;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Predicate;
import com.jn.sqlhelper.datasource.DataSourceRegistry;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.NamedDataSource;
import com.jn.sqlhelper.datasource.config.DynamicDataSourcesProperties;
import com.jn.sqlhelper.datasource.factory.CentralizedDataSourceFactory;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import com.jn.sqlhelper.datasource.key.MethodDataSourceKeyRegistry;
import com.jn.sqlhelper.datasource.key.MethodInvocationDataSourceKeySelector;
import com.jn.sqlhelper.datasource.key.WriteOperationMethodMatcher;
import com.jn.sqlhelper.datasource.key.parser.DataSourceKeyAnnotationParser;
import com.jn.sqlhelper.datasource.key.parser.DataSourceKeyDataSourceParser;
import com.jn.sqlhelper.datasource.key.router.DataSourceKeyRouter;
import com.jn.sqlhelper.datasource.spring.boot.SpringDataSourcePropertiesAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@ConditionalOnProperty(name={"sqlhelper.dynamic-datasource.enabled"}, havingValue="true", matchIfMissing=false)
public class DynamicDataSourcesAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourcesAutoConfiguration.class);

    @Bean
    public DataSourceRegistry dataSourceRegistry(ObjectProvider<DataSourceKeyDataSourceParser> dataSourceKeyParserProvider) {
        DataSourceRegistry dataSourceRegistry = new DataSourceRegistry();
        DataSourceKeyDataSourceParser dataSourceKeyParser = (DataSourceKeyDataSourceParser)dataSourceKeyParserProvider.getIfAvailable();
        dataSourceRegistry.setKeyParser(dataSourceKeyParser);
        return dataSourceRegistry;
    }

    @Bean
    public CentralizedDataSourceFactory centralizedDataSourceFactory(DataSourceRegistry dataSourceRegistry) {
        CentralizedDataSourceFactory factory = new CentralizedDataSourceFactory();
        factory.setRegistry(dataSourceRegistry);
        return factory;
    }

    @Bean
    @ConfigurationProperties(prefix="sqlhelper.dynamic-datasource")
    public DynamicDataSourcesProperties namedDataSourcesProperties(Environment environment) {
        String requiredClass;
        String keyChoicesPointcutExpression = environment.getProperty("sqlhelper.dynamic-datasource.key-choices.expression");
        if (Strings.isNotBlank((String)keyChoicesPointcutExpression) && !ClassLoaders.hasClass((String)(requiredClass = "com.jn.langx.invocation.aop.expression.AspectJExpressionPointcutAdvisorProperties"), (ClassLoader)this.getClass().getClassLoader())) {
            StringBuilder log = new StringBuilder("The configuration property 'sqlhelper.dynamicDataSource.key-choices.expression' has specified, but can't find the class: '" + requiredClass + "', you should import the following jars to your classpath:\n").append("\t1) com.github.fangjinuo.agilway:agileway-spring:${agileway.version}.jar\n").append("\t2) org.springframework:spring-aop:${spring.version}.jar\n").append("\t3) org.aspectj:aspectjweaver:${aspectj.version}.jar\n").append("\t4) com.github.fangjinuo.langx:langx-java:${langx-java.version}.jar\n");
            logger.warn(log.toString());
        }
        return new DynamicDataSourcesProperties();
    }

    @Bean(name={"dataSourcesFactoryBean"})
    public ListFactoryBean dataSourcesFactoryBean(final CentralizedDataSourceFactory centralizedDataSourceFactory, DynamicDataSourcesProperties dynamicDataSourcesProperties, ObjectProvider<DataSource> springBootOriginDataSourceProvider, ObjectProvider<DataSourceProperties> builtInDataSourceProperties, ApplicationContext applicationContext) {
        DataSourceProperties properties;
        logger.info("===[SQLHelper & Dynamic DataSource]=== the dynamic datasource is enabled");
        final List dataSources = Collects.emptyArrayList();
        DataSource springBootOriginDataSource = (DataSource)springBootOriginDataSourceProvider.getIfAvailable();
        boolean isTestDB = true;
        if (springBootOriginDataSource != null && Objs.equals((Object)(properties = (DataSourceProperties)builtInDataSourceProperties.getObject()).determineUrl(), (Object)properties.getUrl())) {
            isTestDB = false;
        }
        List<com.jn.sqlhelper.datasource.config.DataSourceProperties> dataSourcePropertiesList = dynamicDataSourcesProperties.getDatasources();
        final AbstractAutowireCapableBeanFactory beanFactory = (AbstractAutowireCapableBeanFactory)applicationContext.getAutowireCapableBeanFactory();
        Pipeline.of(dataSourcePropertiesList).forEach((Consumer)new Consumer<com.jn.sqlhelper.datasource.config.DataSourceProperties>(){

            public void accept(com.jn.sqlhelper.datasource.config.DataSourceProperties dataSourceProperties) {
                NamedDataSource namedDataSource = centralizedDataSourceFactory.get(dataSourceProperties);
                if (namedDataSource != null) {
                    String beanName = namedDataSource.getDataSourceKey().getId();
                    beanFactory.registerSingleton(beanName, (Object)namedDataSource);
                    logger.info("===[SQLHelper & Dynamic DataSource]=== register jdbc datasource bean {} to spring bean factory", (Object)beanName);
                    dataSources.add(namedDataSource);
                }
            }
        });
        if (!isTestDB) {
            com.jn.sqlhelper.datasource.config.DataSourceProperties dataSourceProperties = SpringDataSourcePropertiesAdapter.adapt((DataSourceProperties)builtInDataSourceProperties.getObject());
            NamedDataSource namedDataSource = DataSources.toNamedDataSource(springBootOriginDataSource, dataSourceProperties.getName(), dataSourceProperties);
            if (dataSources.isEmpty()) {
                namedDataSource.setName("primary");
            }
            logger.info("===[SQLHelper & Dynamic DataSource]=== register spring boot datasource {} to datasource registry", (Object)namedDataSource.getDataSourceKey());
            centralizedDataSourceFactory.getRegistry().register(namedDataSource);
            dataSources.add(namedDataSource);
        }
        if (logger.isInfoEnabled() && !dataSources.isEmpty()) {
            StringBuilder log = new StringBuilder(256);
            log.append("===[SQLHelper & Dynamic DataSource]=== will load dataSources:\n\t");
            Collection keys = Collects.map((Object)dataSources, (Function)new Function<NamedDataSource, DataSourceKey>(){

                public DataSourceKey apply(NamedDataSource namedDataSource) {
                    return namedDataSource.getDataSourceKey();
                }
            });
            log.append(Strings.join((String)"\n\t", (Iterable)keys));
            logger.info(log.toString());
        }
        ListFactoryBean dataSourcesFactoryBean = new ListFactoryBean();
        dataSourcesFactoryBean.setTargetListClass(ArrayList.class);
        dataSourcesFactoryBean.setSourceList(dataSources);
        return dataSourcesFactoryBean;
    }

    @Bean
    public MethodDataSourceKeyRegistry dataSourceKeyRegistry(ObjectProvider<List<DataSourceKeyAnnotationParser>> dataSourceKeyAnnotationParsersProvider) {
        final MethodDataSourceKeyRegistry registry = new MethodDataSourceKeyRegistry();
        List parsers = (List)dataSourceKeyAnnotationParsersProvider.getIfAvailable();
        Collects.forEach((Iterable)parsers, (Consumer)new Consumer<DataSourceKeyAnnotationParser>(){

            public void accept(DataSourceKeyAnnotationParser dataSourceKeyAnnotationParser) {
                registry.registerDataSourceKeyParser(dataSourceKeyAnnotationParser);
            }
        });
        return registry;
    }

    @Bean
    public MethodInvocationDataSourceKeySelector dataSourceKeySelector(DataSourceRegistry registry, MethodDataSourceKeyRegistry keyRegistry, ObjectProvider<List<DataSourceKeyRouter>> routersProvider, DynamicDataSourcesProperties dataSourcesProperties) {
        DataSourceKeyRouter defaultRouter;
        final MethodInvocationDataSourceKeySelector selector = new MethodInvocationDataSourceKeySelector();
        selector.setDataSourceKeyRegistry(keyRegistry);
        selector.setDataSourceRegistry(registry);
        List routers = (List)routersProvider.getIfAvailable();
        selector.registerRouters(routers);
        final String defaultRouterName = dataSourcesProperties.getDefaultRouter();
        if (Emptys.isNotEmpty((Object)defaultRouterName) && (defaultRouter = (DataSourceKeyRouter)Collects.findFirst((Collection)routers, (Predicate)new Predicate<DataSourceKeyRouter>(){

            public boolean test(DataSourceKeyRouter dataSourceKeyRouter) {
                return defaultRouterName.equals(dataSourceKeyRouter.getName());
            }
        })) != null) {
            selector.setDefaultRouter(defaultRouter);
        }
        Map<String, String> groupToRoutersMap = dataSourcesProperties.getGroupRouters();
        Collects.forEach(groupToRoutersMap, (Consumer2)new Consumer2<String, String>(){

            public void accept(String group, String router) {
                selector.allocateRouter(group, router);
            }
        });
        Map<String, String> groupToWritePattern = dataSourcesProperties.getGroupWriterPatternMap();
        Collects.forEach(groupToWritePattern, (Consumer2)new Consumer2<String, String>(){

            public void accept(String group, String writePattern) {
                WriteOperationMethodMatcher writeOperationMethodMatcher = new WriteOperationMethodMatcher(writePattern);
                selector.allocateWriteMatcher(group, writeOperationMethodMatcher);
            }
        });
        selector.init();
        return selector;
    }
}

