/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.agileway.spring.aop.AspectJExpressionPointcutAdvisorBuilder;
import com.jn.langx.invocation.aop.expression.AspectJExpressionPointcutAdvisorProperties;
import com.jn.sqlhelper.datasource.config.DynamicDataSourcesProperties;
import com.jn.sqlhelper.datasource.key.MethodDataSourceKeyRegistry;
import com.jn.sqlhelper.datasource.spring.aop.DataSourceKeyChoicesAnnotationMethodInterceptor;
import org.aopalliance.intercept.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"sqlhelper.dynamic-datasource.enabled"}, havingValue="true")
@ConditionalOnClass(value={AspectJExpressionPointcutAdvisorProperties.class})
public class DynamicMethodDataSourcesKeyAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicMethodDataSourcesKeyAutoConfiguration.class);

    @Bean(value={"annotationKeyChoicesAdvisor"})
    @ConditionalOnProperty(prefix="sqlhelper.dynamic-datasource.key-choices", name={"expression"})
    @ConditionalOnMissingBean(name={"annotationKeyChoicesAdvisor"})
    public AspectJExpressionPointcutAdvisor keyChoicesAdvisor(DynamicDataSourcesProperties namedDataSourcesProperties, MethodDataSourceKeyRegistry keyRegistry) {
        DataSourceKeyChoicesAnnotationMethodInterceptor interceptor = new DataSourceKeyChoicesAnnotationMethodInterceptor();
        interceptor.setKeyRegistry(keyRegistry);
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisorBuilder().properties(namedDataSourcesProperties.getKeyChoices()).interceptor((Interceptor)interceptor).build();
        logger.info("===[SQLHelper & Dynamic DataSource]=== Add datasource key choices interceptor, use an expression: {}", (Object)namedDataSourcesProperties.getKeyChoices().getExpression());
        return advisor;
    }
}

