/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.agileway.spring.aop.AspectJExpressionPointcutAdvisorBuilder;
import com.jn.langx.invocation.aop.expression.AspectJExpressionPointcutAdvisorProperties;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.logging.Level;
import com.jn.langx.util.logging.Loggers;
import com.jn.sqlhelper.common.transaction.DefaultTransactionManager;
import com.jn.sqlhelper.common.transaction.TransactionDefinitionRegistry;
import com.jn.sqlhelper.common.transaction.TransactionManager;
import com.jn.sqlhelper.common.transaction.definition.parser.TransactionDefinitionParser;
import com.jn.sqlhelper.datasource.config.DynamicDataSourcesProperties;
import com.jn.sqlhelper.datasource.spring.aop.LocalizeGlobalTransactionInterceptor;
import com.jn.sqlhelper.datasource.spring.boot.DynamicDataSourcesAutoConfiguration;
import com.jn.sqlhelper.datasource.spring.transaction.definition.EmptyTransactionAttributeSource;
import com.jn.sqlhelper.datasource.spring.transaction.definition.SpringTransactionAttributeSourceAdapter;
import com.jn.sqlhelper.datasource.spring.transaction.definition.SpringTransactionalAnnotationParser;
import java.util.List;
import org.aopalliance.intercept.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@AutoConfigureAfter(value={DynamicDataSourcesAutoConfiguration.class})
@ConditionalOnProperty(name={"sqlhelper.dynamic-datasource.enabled"}, havingValue="true")
@ConditionalOnClass(value={AspectJExpressionPointcutAdvisorProperties.class})
public class DynamicTransactionAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(DynamicDataSourcesAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(prefix="sqlhelper.dynamic-datasource.transaction", name={"expression"})
    public TransactionManager dynamicTransactionManager() {
        DefaultTransactionManager transactionManager = new DefaultTransactionManager();
        Loggers.log((int)3, (Logger)logger, (Level)Level.INFO, null, (String)"===[SQLHelper & Dynamic Transaction]=== the sqlhelper dynamic datasource transaction manager is enabled with the configuration: sqlhelper.dynamicDataSource.transaction, so you should make sure the spring transaction manager is not enabled", (Object[])new Object[0]);
        return transactionManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="sqlhelper.dynamic-datasource.transaction", name={"expression"})
    public SpringTransactionalAnnotationParser springTransactionalAnnotationParser() {
        return new SpringTransactionalAnnotationParser();
    }

    @Bean
    @ConditionalOnProperty(prefix="sqlhelper.dynamic-datasource.transaction", name={"expression"})
    public TransactionDefinitionRegistry transactionDefinitionRegistry(ObjectProvider<List<TransactionDefinitionParser>> parserProvider, @Qualifier(value="dataSourcesFactoryBean") ListFactoryBean dataSourcesFactoryBean, ObjectProvider<List<TransactionInterceptor>> springTransactionInterceptorProvider) {
        final TransactionDefinitionRegistry registry = new TransactionDefinitionRegistry();
        List parsers = (List)parserProvider.getIfAvailable();
        Collects.forEach((Iterable)parsers, (Consumer)new Consumer<TransactionDefinitionParser>(){

            public void accept(TransactionDefinitionParser parser) {
                registry.register(parser);
            }
        });
        List springTransactionInterceptors = (List)springTransactionInterceptorProvider.getIfAvailable();
        if (Emptys.isNotEmpty((Object)springTransactionInterceptors)) {
            final EmptyTransactionAttributeSource replacement = new EmptyTransactionAttributeSource();
            Collects.forEach((Iterable)springTransactionInterceptors, (Consumer)new Consumer<TransactionInterceptor>(){

                public void accept(TransactionInterceptor springTransactionInterceptor) {
                    TransactionAttributeSource attributeSource = springTransactionInterceptor.getTransactionAttributeSource();
                    if (attributeSource != null) {
                        springTransactionInterceptor.setTransactionAttributeSource(replacement);
                        SpringTransactionAttributeSourceAdapter parser = new SpringTransactionAttributeSourceAdapter(attributeSource);
                        registry.register((TransactionDefinitionParser)parser);
                    }
                }
            });
        }
        return registry;
    }

    @Bean(value={"dynamicDataSourceTransactionAdvisor"})
    @ConditionalOnProperty(prefix="sqlhelper.dynamic-datasource.transaction", name={"expression"})
    @ConditionalOnMissingBean(name={"dynamicDataSourceTransactionAdvisor"})
    public AspectJExpressionPointcutAdvisor dynamicDataSourceTransactionAdvisor(DynamicDataSourcesProperties properties, TransactionManager transactionManager, TransactionDefinitionRegistry registry) {
        LocalizeGlobalTransactionInterceptor interceptor = new LocalizeGlobalTransactionInterceptor();
        interceptor.setTransactionManager(transactionManager);
        interceptor.setDefinitionRegistry(registry);
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisorBuilder().properties(properties.getTransaction()).interceptor((Interceptor)interceptor).build();
        logger.info("===[SQLHelper & Dynamic Transaction]=== Add dynamic datasource transaction interceptor, use an expression: {}", (Object)properties.getTransaction().getExpression());
        return advisor;
    }
}

