/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.datasource.spring.boot;

import com.jn.langx.util.Emptys;
import com.jn.sqlhelper.datasource.DataSources;
import com.jn.sqlhelper.datasource.key.DataSourceKey;
import java.util.UUID;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;

public class SpringDataSourcePropertiesAdapter {
    public static com.jn.sqlhelper.datasource.config.DataSourceProperties adapt(DataSourceProperties properties) {
        com.jn.sqlhelper.datasource.config.DataSourceProperties dataSourceProperties = new com.jn.sqlhelper.datasource.config.DataSourceProperties();
        dataSourceProperties.setUsername(properties.getUsername());
        dataSourceProperties.setPassword(properties.getPassword());
        dataSourceProperties.setDriverClassName(properties.getDriverClassName());
        String name = properties.getName();
        if (Emptys.isEmpty((Object)name)) {
            name = UUID.randomUUID().toString();
        } else {
            DataSourceKey key = null;
            try {
                key = DataSources.buildDataSourceKey(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (key != null) {
                dataSourceProperties.setGroup(key.getGroup());
                dataSourceProperties.setName(key.getName());
            } else {
                dataSourceProperties.setName(name);
            }
        }
        dataSourceProperties.setName(name);
        dataSourceProperties.setUrl(properties.getUrl());
        return dataSourceProperties;
    }
}

