/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect;

import com.jn.langx.util.Objects;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.dialect.SqlRequest;
import com.jn.sqlhelper.dialect.SqlRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlRequestContextHolder {
    private static final Logger logger = LoggerFactory.getLogger(SqlRequestContextHolder.class);
    protected static final ThreadLocal<SqlRequestContext> variables = new ThreadLocal();
    private static final SqlRequestContextHolder INSTANCE = new SqlRequestContextHolder();

    public static SqlRequestContextHolder getInstance() {
        return INSTANCE;
    }

    public SqlRequestContext get() {
        return variables.get();
    }

    public boolean isOrderByRequest() {
        SqlRequestContext ctx = this.get();
        return Objects.isNotNull((Object)((Object)ctx)) && ctx.isOrderByRequest();
    }

    public void setSqlRequest(final SqlRequest request) {
        this.setContextContent(new Consumer<SqlRequestContext>(){

            public void accept(SqlRequestContext context) {
                context.setRequest(request);
                request.setContext(context);
            }
        });
    }

    private <X> void setContextContent(Consumer<SqlRequestContext> consumer) {
        SqlRequestContext context = this.get();
        try {
            if (Objects.isNull((Object)((Object)context)) && Objects.isNull((Object)((Object)(context = (SqlRequestContext)((Object)SqlRequestContext.class.newInstance()))))) {
                variables.remove();
            }
            if (Objects.isNotNull((Object)((Object)context))) {
                variables.set(context);
                consumer.accept((Object)context);
            }
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage(), ex);
        }
    }

    public void clear() {
        SqlRequestContext requestContext = this.get();
        if (Objects.isNotNull((Object)((Object)requestContext))) {
            requestContext.clear();
        }
        variables.remove();
    }
}

