/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Strings;
import com.jn.sqlhelper.common.utils.SQLs;
import com.jn.sqlhelper.dialect.SelectRequest;
import com.jn.sqlhelper.dialect.SqlRequest;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import com.jn.sqlhelper.dialect.orderby.OrderByBuilder;
import com.jn.sqlhelper.dialect.orderby.SqlStyleOrderByBuilder;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContextHolder;

public class SqlRequests
extends SQLs {
    public static SelectRequest prepareSelect(@Nullable boolean escapeLikeParameter) {
        return SqlRequests.prepareSelect(escapeLikeParameter, null, null, null);
    }

    public static SelectRequest prepareSelect(@Nullable Boolean escapeLikeParameter, @Nullable LikeEscaper likeEscaper) {
        return SqlRequests.prepareSelect(escapeLikeParameter, likeEscaper, null, null);
    }

    public static SelectRequest prepareSelect(@Nullable Boolean escapeLikeParameter, @Nullable LikeEscaper likeEscaper, @Nullable String sort, @Nullable OrderByBuilder<String> orderByBuilder) {
        return SqlRequests.prepareSelect(escapeLikeParameter, likeEscaper, sort, orderByBuilder, null, null, -1);
    }

    public static SelectRequest prepareSelect(@Nullable Boolean escapeLikeParameter, @Nullable LikeEscaper likeEscaper, @Nullable String sort, @Nullable OrderByBuilder<String> orderByBuilder, @Nullable Integer timeout, @Nullable Integer fetchSize, int maxRows) {
        SelectRequest request = new SelectRequest();
        ((SqlRequest)((SqlRequest)request.setLikeEscaper(likeEscaper)).setEscapeLikeParameter(escapeLikeParameter)).setFetchSize(fetchSize);
        request.setTimeout(timeout);
        if (maxRows < 0) {
            maxRows = -1;
        }
        request.setMaxRows(maxRows);
        if (Strings.isNotEmpty((String)sort)) {
            if (orderByBuilder == null) {
                orderByBuilder = SqlStyleOrderByBuilder.DEFAULT;
            }
            request.setOrderBy(orderByBuilder.build(sort));
        }
        return request;
    }

    public static <C, E> PagingRequest<C, E> preparePagination(int pageNo, int pageSize) {
        return SqlRequests.preparePagination(pageNo, pageSize, null);
    }

    public static <C, E> PagingRequest<C, E> preparePagination(int pageNo, int pageSize, String sort) {
        return SqlRequests.preparePagination(pageNo, pageSize, sort, null);
    }

    public static <C, E> PagingRequest<C, E> preparePagination(int pageNo, int pageSize, String sort, OrderByBuilder<String> orderByBuilder) {
        return SqlRequests.preparePagination(pageNo, pageSize, sort, orderByBuilder, true);
    }

    public static <C, E> PagingRequest<C, E> preparePagination(int pageNo, int pageSize, String sort, OrderByBuilder<String> orderByBuilder, String dialect) {
        return SqlRequests.preparePagination(pageNo, pageSize, sort, orderByBuilder, dialect, true, null);
    }

    public static <C, E> PagingRequest<C, E> preparePagination(int pageNo, int pageSize, String sort, OrderByBuilder<String> orderByBuilder, boolean count) {
        return SqlRequests.preparePagination(pageNo, pageSize, sort, orderByBuilder, null, count, null);
    }

    public static <C, E> PagingRequest<C, E> preparePagination(int pageNo, int pageSize, String sort, OrderByBuilder<String> orderByBuilder, String dialect, boolean count, String countColumn) {
        PagingRequest pagingRequest = new PagingRequest().limit(pageNo, pageSize);
        if (Strings.isNotEmpty((String)sort)) {
            if (orderByBuilder == null) {
                orderByBuilder = SqlStyleOrderByBuilder.DEFAULT;
            }
            pagingRequest.setOrderBy(orderByBuilder.build(sort));
        }
        if (Strings.isNotEmpty((String)dialect)) {
            pagingRequest.setDialect(dialect);
        }
        pagingRequest.setCount(count);
        if (Strings.isNotEmpty((String)countColumn)) {
            pagingRequest.setCountColumn(countColumn);
        }
        PagingRequestContextHolder.getContext().setPagingRequest(pagingRequest);
        return pagingRequest;
    }
}

