/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.expression.builder;

import com.jn.langx.util.Numbers;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.sqlhelper.dialect.expression.AddExpression;
import com.jn.sqlhelper.dialect.expression.AllExpression;
import com.jn.sqlhelper.dialect.expression.AndExpression;
import com.jn.sqlhelper.dialect.expression.AnyExpression;
import com.jn.sqlhelper.dialect.expression.BetweenAndExpression;
import com.jn.sqlhelper.dialect.expression.ColumnExpression;
import com.jn.sqlhelper.dialect.expression.DivideExpression;
import com.jn.sqlhelper.dialect.expression.DoubleExpression;
import com.jn.sqlhelper.dialect.expression.EqualExpression;
import com.jn.sqlhelper.dialect.expression.ExistsExpression;
import com.jn.sqlhelper.dialect.expression.GreaterOrEqualExpression;
import com.jn.sqlhelper.dialect.expression.GreaterThanExpression;
import com.jn.sqlhelper.dialect.expression.InExpression;
import com.jn.sqlhelper.dialect.expression.IntegerOrLongExpression;
import com.jn.sqlhelper.dialect.expression.IsNullExpression;
import com.jn.sqlhelper.dialect.expression.LesserOrEqualExpression;
import com.jn.sqlhelper.dialect.expression.LesserThanExpression;
import com.jn.sqlhelper.dialect.expression.LikeExpression;
import com.jn.sqlhelper.dialect.expression.ListExpression;
import com.jn.sqlhelper.dialect.expression.ModeExpression;
import com.jn.sqlhelper.dialect.expression.MultipleExpression;
import com.jn.sqlhelper.dialect.expression.NotEqualExpression;
import com.jn.sqlhelper.dialect.expression.OrExpression;
import com.jn.sqlhelper.dialect.expression.PlaceholderExpression;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.dialect.expression.StringExpression;
import com.jn.sqlhelper.dialect.expression.SubtractExpression;
import com.jn.sqlhelper.dialect.expression.ValueExpression;
import com.jn.sqlhelper.dialect.expression.builder.BinaryOperatorExpressionBuilder;
import com.jn.sqlhelper.dialect.expression.builder.SQLExpressionBuilder;
import com.jn.sqlhelper.dialect.expression.builder.UnaryOperatorExpressionBuilder;
import java.util.List;

public class SQLExpressionBuilders {
    private SQLExpressionBuilders() {
    }

    public static boolean isPlaceholderExpression(SQLExpression expression) {
        if (expression == null) {
            return false;
        }
        return expression instanceof PlaceholderExpression;
    }

    public static class ExistsBuilder
    extends UnaryOperatorExpressionBuilder<ExistsExpression, ExistsBuilder> {
        public ExistsBuilder() {
            this(false);
        }

        public ExistsBuilder(final boolean isNotExpression) {
            this.supplier(new Supplier0<ExistsExpression>(){

                public ExistsExpression get() {
                    return new ExistsExpression(isNotExpression);
                }
            });
        }
    }

    public static class AnyBuilder
    extends UnaryOperatorExpressionBuilder<AnyExpression, AnyBuilder> {
        public AnyBuilder() {
            this.supplier(new Supplier0<AnyExpression>(){

                public AnyExpression get() {
                    return new AnyExpression();
                }
            });
        }
    }

    public static class AllBuilder
    extends UnaryOperatorExpressionBuilder<AllExpression, AllBuilder> {
        public AllBuilder() {
            this.supplier(new Supplier0<AllExpression>(){

                public AllExpression get() {
                    return new AllExpression();
                }
            });
        }
    }

    public static class LikeBuilder
    extends BinaryOperatorExpressionBuilder<LikeExpression, LikeBuilder> {
        public LikeBuilder() {
            this(false, null);
        }

        public LikeBuilder(char escape) {
            this(false, Character.valueOf(escape));
        }

        public LikeBuilder(final boolean isNotExpression, final Character escape) {
            this.supplier(new Supplier0<LikeExpression>(){

                public LikeExpression get() {
                    LikeExpression like = new LikeExpression(isNotExpression);
                    if (escape != null) {
                        like.setEscape(escape.charValue());
                    }
                    return like;
                }
            });
        }
    }

    public static class BetweenAndBuilder
    implements SQLExpressionBuilder<BetweenAndExpression> {
        private BetweenAndExpression between = new BetweenAndExpression();

        public BetweenAndBuilder not(boolean isNotExpression) {
            this.between.not(isNotExpression);
            return this;
        }

        public BetweenAndBuilder target(SQLExpression target) {
            this.between.setTarget(target);
            return this;
        }

        public BetweenAndBuilder low(int low) {
            this.between.setLow(new IntegerOrLongExpression(low));
            return this;
        }

        public BetweenAndBuilder low(long low) {
            this.between.setLow(new IntegerOrLongExpression(low));
            return this;
        }

        public BetweenAndBuilder low(double low) {
            this.between.setLow(new DoubleExpression(low));
            return this;
        }

        public BetweenAndBuilder low(String low) {
            this.between.setLow(new StringExpression(low));
            return this;
        }

        public BetweenAndBuilder low(SQLExpression low) {
            this.between.setLow(low);
            return this;
        }

        public BetweenAndBuilder high(int low) {
            this.between.setHigh(new IntegerOrLongExpression(low));
            return this;
        }

        public BetweenAndBuilder high(long low) {
            this.between.setHigh(new IntegerOrLongExpression(low));
            return this;
        }

        public BetweenAndBuilder high(double low) {
            this.between.setHigh(new DoubleExpression(low));
            return this;
        }

        public BetweenAndBuilder high(String low) {
            this.between.setHigh(new StringExpression(low));
            return this;
        }

        public BetweenAndBuilder high(SQLExpression high) {
            this.between.setHigh(high);
            return this;
        }

        public BetweenAndExpression build() {
            return this.between;
        }
    }

    public static class IsNullBuilder
    extends UnaryOperatorExpressionBuilder<IsNullExpression, IsNullBuilder> {
        public IsNullBuilder() {
            this(false);
        }

        public IsNullBuilder(final boolean not) {
            this.supplier(new Supplier0<IsNullExpression>(){

                public IsNullExpression get() {
                    return new IsNullExpression(not);
                }
            });
        }
    }

    public static class InBuilder
    extends BinaryOperatorExpressionBuilder<InExpression, InBuilder> {
        ListExpressionBuilder listExpressionBuilder = new ListExpressionBuilder();

        public InBuilder() {
            this(false);
        }

        public InBuilder(final boolean not) {
            this.supplier(new Supplier0<InExpression>(){

                public InExpression get() {
                    return new InExpression(not);
                }
            });
            this.right(this.listExpressionBuilder.getListExpression());
        }

        public InBuilder addValue(long value) {
            this.listExpressionBuilder.addValue(value);
            return this;
        }

        public InBuilder addValue(double value) {
            this.listExpressionBuilder.addValue(value);
            return this;
        }

        public InBuilder addValue(String value) {
            this.listExpressionBuilder.addValue(value);
            return this;
        }

        public InBuilder addValue(SQLExpression value) {
            this.listExpressionBuilder.addValue(value);
            return this;
        }

        public InBuilder addValues(List<?> values) {
            this.listExpressionBuilder.addValues(values);
            return this;
        }
    }

    public static class LesserOrEqualBuilder
    extends BinaryOperatorExpressionBuilder<LesserOrEqualExpression, LesserOrEqualBuilder> {
        public LesserOrEqualBuilder() {
            this.supplier(new Supplier0<LesserOrEqualExpression>(){

                public LesserOrEqualExpression get() {
                    return new LesserOrEqualExpression();
                }
            });
        }
    }

    public static class LesserThanBuilder
    extends BinaryOperatorExpressionBuilder<LesserThanExpression, LesserThanBuilder> {
        public LesserThanBuilder() {
            this.supplier(new Supplier0<LesserThanExpression>(){

                public LesserThanExpression get() {
                    return new LesserThanExpression();
                }
            });
        }
    }

    public static class GreaterOrEqualBuilder
    extends BinaryOperatorExpressionBuilder<GreaterOrEqualExpression, GreaterOrEqualBuilder> {
        public GreaterOrEqualBuilder() {
            this.supplier(new Supplier0<GreaterOrEqualExpression>(){

                public GreaterOrEqualExpression get() {
                    return new GreaterOrEqualExpression();
                }
            });
        }
    }

    public static class GreaterThanBuilder
    extends BinaryOperatorExpressionBuilder<GreaterThanExpression, GreaterThanBuilder> {
        public GreaterThanBuilder() {
            this.supplier(new Supplier0<GreaterThanExpression>(){

                public GreaterThanExpression get() {
                    return new GreaterThanExpression();
                }
            });
        }
    }

    public static class NotEqualBuilder
    extends BinaryOperatorExpressionBuilder<NotEqualExpression, NotEqualBuilder> {
        public NotEqualBuilder() {
            this.supplier(new Supplier0<NotEqualExpression>(){

                public NotEqualExpression get() {
                    return new NotEqualExpression();
                }
            });
        }
    }

    public static class EqualBuilder
    extends BinaryOperatorExpressionBuilder<EqualExpression, EqualBuilder> {
        public EqualBuilder() {
            this.supplier(new Supplier0<EqualExpression>(){

                public EqualExpression get() {
                    return new EqualExpression();
                }
            });
        }
    }

    public static class OrBuilder
    extends BinaryOperatorExpressionBuilder<OrExpression, OrBuilder> {
        public OrBuilder() {
            this.supplier(new Supplier0<OrExpression>(){

                public OrExpression get() {
                    return new OrExpression();
                }
            });
        }
    }

    public static class AndBuilder
    extends BinaryOperatorExpressionBuilder<AndExpression, AndBuilder> {
        public AndBuilder() {
            this.supplier(new Supplier0<AndExpression>(){

                public AndExpression get() {
                    return new AndExpression();
                }
            });
        }
    }

    public static class ModeBuilder
    extends BinaryOperatorExpressionBuilder<ModeExpression, ModeBuilder> {
        public ModeBuilder() {
            this.supplier(new Supplier0<ModeExpression>(){

                public ModeExpression get() {
                    return new ModeExpression();
                }
            });
        }
    }

    public static class DivideBuilder
    extends BinaryOperatorExpressionBuilder<DivideExpression, DivideBuilder> {
        public DivideBuilder() {
            this.supplier(new Supplier0<DivideExpression>(){

                public DivideExpression get() {
                    return new DivideExpression();
                }
            });
        }
    }

    public static class MultipleBuilder
    extends BinaryOperatorExpressionBuilder<MultipleExpression, MultipleBuilder> {
        public MultipleBuilder() {
            this.supplier(new Supplier0<MultipleExpression>(){

                public MultipleExpression get() {
                    return new MultipleExpression();
                }
            });
        }
    }

    public static class SubtractBuilder
    extends BinaryOperatorExpressionBuilder<SubtractExpression, SubtractBuilder> {
        public SubtractBuilder() {
            this.supplier(new Supplier0<SubtractExpression>(){

                public SubtractExpression get() {
                    return new SubtractExpression();
                }
            });
        }
    }

    public static class AddBuilder
    extends BinaryOperatorExpressionBuilder<AddExpression, AddBuilder> {
        public AddBuilder() {
            this.supplier(new Supplier0<AddExpression>(){

                public AddExpression get() {
                    return new AddExpression();
                }
            });
        }
    }

    public static class ListExpressionBuilder
    implements SQLExpressionBuilder<ListExpression> {
        private ListExpression list = new ListExpression();

        public ListExpression getListExpression() {
            return this.list;
        }

        public ListExpressionBuilder addValue(String value) {
            this.list.add(new StringExpression(value));
            return this;
        }

        public ListExpressionBuilder addValue(int value) {
            this.list.add(new IntegerOrLongExpression(value));
            return this;
        }

        public ListExpressionBuilder addValue(long value) {
            this.list.add(new IntegerOrLongExpression(value));
            return this;
        }

        public ListExpressionBuilder addValue(double value) {
            this.list.add(new DoubleExpression(value));
            return this;
        }

        public ListExpressionBuilder addValue(SQLExpression expression) {
            this.list.add(expression);
            return this;
        }

        public ListExpressionBuilder addValues(List<?> values) {
            Collects.forEach(values, (Predicate)new Predicate(){

                public boolean test(Object value) {
                    return value != null;
                }
            }, (Consumer)new Consumer(){

                public void accept(Object o) {
                    Class clazz = Primitives.wrap(o.getClass());
                    if (clazz == String.class || clazz == Character.class) {
                        ListExpressionBuilder.this.addValue((String)o);
                        return;
                    }
                    if (clazz == Short.class || clazz == Byte.class || clazz == Integer.class) {
                        ListExpressionBuilder.this.addValue((Integer)o);
                        return;
                    }
                    if (clazz == Long.class) {
                        ListExpressionBuilder.this.addValue((Long)o);
                        return;
                    }
                    if (clazz == Float.class || clazz == Double.class) {
                        ListExpressionBuilder.this.addValue(Numbers.toDouble((Number)((Number)o)));
                    }
                    ListExpressionBuilder.this.addValue(new ValueExpression<Object>(o));
                }
            });
            return this;
        }

        public ListExpression build() {
            return this.list;
        }
    }

    public static class StringExpressionBuilder
    implements SQLExpressionBuilder<StringExpression> {
        private StringExpression expression = new StringExpression();

        public StringExpressionBuilder value(String value) {
            this.expression.setValue(value);
            return this;
        }

        public StringExpression build() {
            return this.expression;
        }
    }

    public static class DoubleExpressionBuilder
    implements SQLExpressionBuilder<DoubleExpression> {
        private DoubleExpression expression = new DoubleExpression();

        public DoubleExpressionBuilder value(double value) {
            this.expression.setValue(value);
            return this;
        }

        public DoubleExpression build() {
            return this.expression;
        }
    }

    public static class IntegerOrLongExpressionBuilder
    implements SQLExpressionBuilder<IntegerOrLongExpression> {
        private IntegerOrLongExpression expression = new IntegerOrLongExpression();

        public IntegerOrLongExpressionBuilder value(long value) {
            this.expression.setValue(value);
            return this;
        }

        public IntegerOrLongExpressionBuilder value(int value) {
            this.expression.setValue(Numbers.toLong((Number)value));
            return this;
        }

        public IntegerOrLongExpression build() {
            return this.expression;
        }
    }

    public static class ColumnBuilder
    implements SQLExpressionBuilder<ColumnExpression> {
        private ColumnExpression columnExpression = new ColumnExpression();

        public ColumnBuilder catalog(String catalog) {
            this.columnExpression.setCatalog(catalog);
            return this;
        }

        public ColumnBuilder schema(String schema) {
            this.columnExpression.setSchema(schema);
            return this;
        }

        public ColumnBuilder table(String table) {
            this.columnExpression.setTable(table);
            return this;
        }

        public ColumnBuilder column(String column) {
            this.columnExpression.setColumn(column);
            return this;
        }

        public ColumnBuilder separator(String separator) {
            this.columnExpression.setSeparator(separator);
            return this;
        }

        public ColumnBuilder catalogAtStart(boolean catalogAtStart) {
            this.columnExpression.setCatalogAtStart(catalogAtStart);
            return this;
        }

        public ColumnExpression build() {
            return this.columnExpression;
        }
    }
}

