/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.instrument;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.cache.Cache;
import com.jn.langx.cache.CacheBuilder;
import com.jn.langx.cache.Loader;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Predicate;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.DialectRegistry;
import com.jn.sqlhelper.dialect.SQLDialectException;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.dialect.expression.builder.SQLSymbolExpressionBuilderRegistry;
import com.jn.sqlhelper.dialect.expression.columnevaluation.BuiltinColumnEvaluationExpressionSupplier;
import com.jn.sqlhelper.dialect.expression.columnevaluation.ColumnEvaluationExpressionSupplier;
import com.jn.sqlhelper.dialect.instrument.InjectPosition;
import com.jn.sqlhelper.dialect.instrument.Instrumentation;
import com.jn.sqlhelper.dialect.instrument.InstrumentationRegistry;
import com.jn.sqlhelper.dialect.instrument.InstrumentedStatement;
import com.jn.sqlhelper.dialect.instrument.SQLInstrumentorConfig;
import com.jn.sqlhelper.dialect.instrument.TransformConfig;
import com.jn.sqlhelper.dialect.instrument.orderby.DefaultOrderByTransformer;
import com.jn.sqlhelper.dialect.instrument.orderby.OrderByTransformer;
import com.jn.sqlhelper.dialect.instrument.where.WhereTransformConfig;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.pagination.PagedPreparedParameterSetter;
import com.jn.sqlhelper.dialect.pagination.QueryParameters;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import com.jn.sqlhelper.dialect.sqlparser.SqlStatementWrapper;
import com.jn.sqlhelper.dialect.sqlparser.StringSqlStatementWrapper;
import com.jn.sqlhelper.dialect.tenant.Tenant;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLStatementInstrumentor
implements Initializable {
    private static final Logger logger = LoggerFactory.getLogger(SQLStatementInstrumentor.class);
    private static final ThreadLocal<Dialect> DIALECT_HOLDER = new ThreadLocal();
    private static final List<String> keywordsNotAfterOrderBy = Collects.asList((Object[])new String[]{"select", "?", "union", "from", "where", "and", "or", "between", "in", "case"});
    @NonNull
    private SQLInstrumentorConfig config;
    private DialectRegistry dialectRegistry;
    private volatile boolean inited = false;
    private String name;
    private Instrumentation instrumentation;
    private SQLSymbolExpressionBuilderRegistry sqlSymbolExpressionBuilderRegistry = new SQLSymbolExpressionBuilderRegistry();
    private ColumnEvaluationExpressionSupplier columnEvaluationExpressionSupplier;
    private OrderByTransformer orderByTransformer;
    private Cache<String, InstrumentedStatement> instrumentSqlCache;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void init() throws InitializationException {
        if (!this.inited) {
            if (this.config == null) {
                throw new IllegalStateException("the 'config' field is null");
            }
            this.setName(this.config.getName());
            logger.info("Start to initial the {} SQLStatementInstrumentor with configuration{}", (Object)this.name, (Object)this.config);
            this.dialectRegistry = DialectRegistry.getInstance();
            this.inited = true;
            if (this.config.isCacheInstrumentedSql()) {
                this.instrumentSqlCache = CacheBuilder.newBuilder().initialCapacity(this.config.getCacheInitialCapacity()).maxCapacity(this.config.getCacheMaxCapacity()).concurrencyLevel(Runtime.getRuntime().availableProcessors()).expireAfterRead((long)this.config.getCacheExpireAfterRead()).loader((Loader)new Loader<String, InstrumentedStatement>(){

                    public InstrumentedStatement load(String originalSql) {
                        InstrumentedStatement s = new InstrumentedStatement();
                        s.setOriginalSql(originalSql);
                        return s;
                    }

                    public Map<String, InstrumentedStatement> getAll(Iterable<String> keys) {
                        final HashMap<String, InstrumentedStatement> map = new HashMap<String, InstrumentedStatement>();
                        Collects.forEach(keys, (Consumer)new Consumer<String>(){

                            public void accept(String k) {
                                map.put(k, this.load(k));
                            }
                        });
                        return map;
                    }
                }).build();
            }
            InstrumentationRegistry.getInstance().enableInstrumentation(this.config.getInstrumentation());
            this.instrumentation = InstrumentationRegistry.getInstance().findInstrumentation(this.config.getInstrumentation());
            Preconditions.checkNotNull((Object)this.instrumentation, (String)"Can't find a suitable or enabled SQL instrumentation, please add the sqlhelper-jsqlparser.jar to your classpath");
            this.orderByTransformer = new DefaultOrderByTransformer();
            this.orderByTransformer.setInstrumentation(this.instrumentation);
            this.orderByTransformer.init();
            this.sqlSymbolExpressionBuilderRegistry.init();
            if (this.columnEvaluationExpressionSupplier == null) {
                this.columnEvaluationExpressionSupplier = new BuiltinColumnEvaluationExpressionSupplier();
            }
            this.columnEvaluationExpressionSupplier.setExpressionBuilderRegistry(this.sqlSymbolExpressionBuilderRegistry);
            logger.info("The {} SQLStatementInstrumentor initial finish", (Object)this.name);
        }
    }

    public boolean beginIfSupportsLimit(Statement statement) {
        Dialect dialect = this.getDialect(statement);
        return this.beginIfSupportsLimit(dialect);
    }

    public boolean beginIfSupportsLimit(String databaseId) {
        Dialect dialect = this.dialectRegistry.getDialectByName(databaseId);
        return this.beginIfSupportsLimit(dialect);
    }

    public boolean beginIfSupportsLimit(DatabaseMetaData databaseMetaData) {
        Dialect dialect = this.getDialect(databaseMetaData);
        return this.beginIfSupportsLimit(dialect);
    }

    private boolean beginIfSupportsLimit(Dialect dialect) {
        if (dialect == null) {
            return false;
        }
        boolean supports = dialect.isSupportsLimit();
        if (supports) {
            DIALECT_HOLDER.set(dialect);
        }
        return supports;
    }

    public Dialect getCurrentDialect() {
        return DIALECT_HOLDER.get();
    }

    private Dialect getDialect(Statement statement) {
        Dialect dialect = null;
        if (statement != null) {
            try {
                Connection connection = statement.getConnection();
                dialect = this.getDialect(connection.getMetaData());
            }
            catch (SQLException e) {
                logger.error("sql error code: {}, message: {}", new Object[]{e.getErrorCode(), e.getMessage(), e});
            }
        }
        return dialect;
    }

    public Dialect getDialect(@Nullable DatabaseMetaData databaseMetaData) {
        Dialect dialect = this.getCurrentDialect();
        if (dialect != null) {
            return dialect;
        }
        String dialectName = this.config.getDialect();
        if (dialectName != null) {
            dialect = this.dialectRegistry.getDialectByName(dialectName);
        }
        if (dialect == null && this.config.getDialectClassName() != null) {
            dialect = this.dialectRegistry.getDialectByClassName(this.config.getDialectClassName());
        }
        if (dialect == null && databaseMetaData != null) {
            dialect = this.dialectRegistry.getDialectByDatabaseMetadata(databaseMetaData);
        }
        return dialect;
    }

    public String instrumentLimitSql(String sql, RowSelection selection) {
        Dialect dialect = this.getCurrentDialect();
        return this.instrumentLimitSql(dialect, sql, selection);
    }

    public String instrumentLimitSql(Dialect dialect, String sql, RowSelection selection) {
        if (LimitHelper.useLimit(dialect, selection) && dialect.isSupportsVariableLimit()) {
            String originalSql = sql;
            if (this.config.isCacheInstrumentedSql() && (sql = this.getInstrumentedStatement(originalSql).getLimitSql(dialect.getDatabaseId(), selection.hasOffset())) != null) {
                return sql;
            }
            sql = dialect.getLimitSql(originalSql, selection);
            if (this.config.isCacheInstrumentedSql()) {
                this.getInstrumentedStatement(originalSql).setLimitSql(dialect.getDatabaseId(), sql, selection.hasOffset());
            }
        }
        return sql;
    }

    public String instrumentOrderBySql(String sql, OrderBy orderBy) {
        String orderBySql;
        if (this.config.isCacheInstrumentedSql() && (orderBySql = this.getInstrumentedStatement(sql).getOrderBySql(orderBy)) != null) {
            return orderBySql;
        }
        try {
            SqlStatementWrapper sqlStatementWrapper = this.parseSql(sql);
            TransformConfig transformConfig = new TransformConfig();
            transformConfig.setOrderBy(orderBy);
            this.orderByTransformer.transform(sqlStatementWrapper, transformConfig);
            String sql2 = sqlStatementWrapper.getSql();
            if (sql2 != null) {
                if (this.config.isCacheInstrumentedSql()) {
                    this.getInstrumentedStatement(sql).setOrderBySql(orderBy, sql2);
                }
                return sql2;
            }
        }
        catch (Throwable ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return sql;
    }

    private SqlStatementWrapper parseSql(String sql) {
        try {
            return this.instrumentation.getSqlParser().parse(sql);
        }
        catch (Throwable ex) {
            logger.error("error occur when parse the sql with jsqlparser: {}", (Object)sql);
            StringSqlStatementWrapper sqlStatementWrapper = new StringSqlStatementWrapper();
            sqlStatementWrapper.setOriginalSql(sql);
            sqlStatementWrapper.setStatement(sql);
            return sqlStatementWrapper;
        }
    }

    public String instrumentOrderByLimitSql(String sql, OrderBy orderBy, RowSelection selection) {
        Dialect dialect = this.getCurrentDialect();
        return this.instrumentOrderByLimitSql(sql, orderBy, dialect, selection);
    }

    public String instrumentOrderByLimitSql(String sql, OrderBy orderBy, Dialect dialect, RowSelection selection) {
        String originalSql = sql;
        if (orderBy == null) {
            throw new IllegalArgumentException("Illegal argument : orderBy");
        }
        sql = this.instrumentLimitSql(dialect, sql, selection);
        sql = this.instrumentOrderBySql(sql, orderBy);
        if (this.config.isCacheInstrumentedSql()) {
            this.getInstrumentedStatement(originalSql).setOrderByLimitSql(orderBy, dialect.getDatabaseId(), sql, selection.hasOffset());
        }
        return sql;
    }

    public String instrumentTenantSql(String sql, Tenant tenant) {
        if (tenant == null) {
            return sql;
        }
        try {
            String tenantSql;
            WhereTransformConfig whereTransformConfig = new WhereTransformConfig();
            whereTransformConfig.setInstrumentSubSelect(false);
            whereTransformConfig.setPosition(InjectPosition.FIRST);
            SQLExpression sqlExpression = (SQLExpression)this.columnEvaluationExpressionSupplier.get(tenant);
            whereTransformConfig.setExpression(sqlExpression);
            TransformConfig transformConfig = new TransformConfig();
            transformConfig.setWhereInstrumentConfigs(Collects.asList((Object[])new WhereTransformConfig[]{whereTransformConfig}));
            if (this.config.isCacheInstrumentedSql() && (tenantSql = this.getInstrumentedStatement(sql).getInstrumentedSql(transformConfig)) != null) {
                return tenantSql;
            }
            SqlStatementWrapper statementWrapper = this.parseSql(sql);
            this.instrumentation.getWhereTransformer().transform(statementWrapper, transformConfig);
            String newSql = statementWrapper.getSql();
            if (newSql != null) {
                if (this.config.isCacheInstrumentedSql()) {
                    this.getInstrumentedStatement(sql).setInstrumentedSql(transformConfig, newSql);
                }
                return newSql;
            }
        }
        catch (Throwable ex) {
            logger.warn(ex.getMessage(), ex);
        }
        return sql;
    }

    public void finish() {
        DIALECT_HOLDER.remove();
    }

    public String countSql(String originalSql) {
        return this.countSql(originalSql, null);
    }

    public String countSql(String originalSql, String countColumn) {
        String remainSql;
        String countSql;
        InstrumentedStatement instrumentedSql;
        if (Strings.isBlank((String)countColumn)) {
            countColumn = "1";
        }
        if ((instrumentedSql = this.getInstrumentedStatement(originalSql)) != null && (countSql = instrumentedSql.getCountSql()) != null) {
            return countSql;
        }
        boolean sliceOrderBy = false;
        String lowerSql = originalSql.toLowerCase();
        int orderIndex = lowerSql.lastIndexOf("order");
        if (orderIndex != -1 && (sliceOrderBy = (remainSql = lowerSql.substring(orderIndex + "order".length()).trim()).startsWith("by"))) {
            remainSql = Strings.replace((String)remainSql, (String)"(", (String)" ( ");
            Pipeline pipeline = Pipeline.of((Object[])(remainSql = Strings.replace((String)remainSql, (String)")", (String)" ) ")).split("[\\s,]+")).filter((Predicate)new Predicate<String>(){

                public boolean test(String value) {
                    return Strings.isNotEmpty((String)value);
                }
            });
            if (pipeline.anyMatch((Predicate)new Predicate<String>(){

                public boolean test(String value) {
                    return keywordsNotAfterOrderBy.contains(value);
                }
            })) {
                sliceOrderBy = false;
            }
            if (sliceOrderBy) {
                int leftBracketsCount = 0;
                List list = pipeline.asList();
                for (int i = 0; i < list.size(); ++i) {
                    String c = (String)list.get(i);
                    if (c.equals("(")) {
                        ++leftBracketsCount;
                        continue;
                    }
                    if (!c.equals(")") || --leftBracketsCount >= 0) continue;
                    sliceOrderBy = false;
                    break;
                }
            }
        }
        if (sliceOrderBy) {
            originalSql = originalSql.substring(0, orderIndex).trim();
        }
        String countSql2 = "select count(" + countColumn + ") from (" + originalSql + ") tmp_count";
        if (this.config.isCacheInstrumentedSql()) {
            this.getInstrumentedStatement(originalSql).setCountSql(countSql2);
        }
        return countSql2;
    }

    private InstrumentedStatement getInstrumentedStatement(String originalSql) {
        if (this.config.isCacheInstrumentedSql()) {
            try {
                return (InstrumentedStatement)this.instrumentSqlCache.get((Object)originalSql);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private InstrumentedStatement getInstrumentedStatementIfPresent(String originalSql) {
        if (this.config.isCacheInstrumentedSql()) {
            return (InstrumentedStatement)this.instrumentSqlCache.getIfPresent((Object)originalSql);
        }
        return null;
    }

    public PreparedStatement bindParameters(PreparedStatement statement, PagedPreparedParameterSetter parameterSetter, QueryParameters queryParameters, boolean setOriginalParameters) throws SQLException, SQLDialectException {
        Dialect dialect = this.getDialect(statement);
        return this.bindParameters(dialect, statement, parameterSetter, queryParameters, setOriginalParameters);
    }

    public PreparedStatement bindParameters(Dialect dialect, PreparedStatement statement, PagedPreparedParameterSetter parameterSetter, QueryParameters queryParameters, boolean setOriginalParameters) throws SQLException, SQLDialectException {
        RowSelection selection = queryParameters.getRowSelection();
        boolean callable = queryParameters.isCallable();
        try {
            int col = 1;
            int countOfBeforeSubquery = queryParameters.getBeforeSubqueryParameterCount();
            int countOfAfterSubquery = queryParameters.getAfterSubqueryParameterCount();
            if (setOriginalParameters && countOfBeforeSubquery > 0) {
                col += parameterSetter.setBeforeSubqueryParameters(statement, queryParameters, col);
            }
            col += dialect.bindLimitParametersAtStartOfQuery(selection, statement, col);
            if (callable) {
                col = dialect.registerResultSetOutParameter((CallableStatement)statement, col);
            }
            if (setOriginalParameters) {
                col = countOfBeforeSubquery < 1 && countOfAfterSubquery < 1 ? (col += parameterSetter.setOriginalParameters(statement, queryParameters, col)) : (col += parameterSetter.setSubqueryParameters(statement, queryParameters, col));
            }
            col += dialect.bindLimitParametersAtEndOfQuery(selection, statement, col);
            if (setOriginalParameters && countOfAfterSubquery > 0) {
                col += parameterSetter.setAfterSubqueryParameters(statement, queryParameters, col);
            }
            dialect.setMaxRows(selection, statement);
            if (selection != null) {
                if (selection.getTimeout() != null && selection.getTimeout() > 0) {
                    statement.setQueryTimeout(selection.getTimeout());
                }
                if (selection.getFetchSize() != null && selection.getFetchSize() > 0) {
                    statement.setFetchSize(selection.getFetchSize());
                }
            }
        }
        catch (SQLException ex) {
            logger.error("Set sql parameter fail, errorCode: {}, stack:{}", (Object)ex.getErrorCode(), (Object)ex);
        }
        return statement;
    }

    public SQLInstrumentorConfig getConfig() {
        return this.config;
    }

    @NonNull
    public void setConfig(SQLInstrumentorConfig config) {
        if (!this.inited) {
            this.config = config;
        }
    }

    public DialectRegistry getDialectRegistry() {
        return this.dialectRegistry;
    }

    public void setDialectRegistry(DialectRegistry dialectRegistry) {
        this.dialectRegistry = dialectRegistry;
    }
}

