/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.instrument.orderby;

import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer2;
import com.jn.sqlhelper.dialect.instrument.AbstractClauseTransformer;
import com.jn.sqlhelper.dialect.instrument.TransformConfig;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.orderby.OrderByItem;
import com.jn.sqlhelper.dialect.sqlparser.SqlStatementWrapper;
import java.util.Collection;

public class SimpleOrderByTransformer
extends AbstractClauseTransformer<String> {
    @Override
    public void init() throws InitializationException {
    }

    public boolean isTransformable(SqlStatementWrapper<String> statementWrapper) {
        String statement = statementWrapper.get();
        if (!(statement instanceof String)) {
            return false;
        }
        return Strings.isNotBlank((String)statement.toString());
    }

    @Override
    public SqlStatementWrapper transform(SqlStatementWrapper<String> sw, TransformConfig config) {
        String sql = sw.get();
        OrderBy orderBy = config.getOrderBy();
        sql = SimpleOrderByTransformer.instrumentOrderByUsingStringAppend(sql, orderBy);
        sw.setStatement(sql);
        sw.setChanged(true);
        return sw;
    }

    private static String instrumentOrderByUsingStringAppend(String sql, OrderBy orderBy) {
        final StringBuilder builder = new StringBuilder(sql);
        builder.append(" ORDER BY ");
        Collects.forEach((Collection)Collects.asList((Iterable)orderBy), (Consumer2)new Consumer2<Integer, OrderByItem>(){

            public void accept(Integer index, OrderByItem orderByItem) {
                if (index > 0) {
                    builder.append(",");
                }
                builder.append(" ").append(orderByItem.getExpression()).append(" ").append(orderByItem.getType().name());
            }
        });
        return builder.toString();
    }
}

