/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.annotation.Name;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.reflect.Reflects;
import com.jn.sqlhelper.common.ddl.dump.DatabaseLoader;
import com.jn.sqlhelper.common.ddl.dump.TableGenerator;
import com.jn.sqlhelper.common.ddl.model.DatabaseDescription;
import com.jn.sqlhelper.common.ddl.model.Table;
import com.jn.sqlhelper.common.exception.TableNonExistsException;
import com.jn.sqlhelper.common.utils.SQLs;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.ddl.generator.CommonTableGenerator;
import com.jn.sqlhelper.dialect.internal.limit.DefaultLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHandler;
import com.jn.sqlhelper.dialect.internal.urlparser.CommonUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.NoopUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.UrlParser;
import com.jn.sqlhelper.dialect.likeescaper.BackslashStyleEscaper;
import com.jn.sqlhelper.dialect.likeescaper.LikeEscaper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.sql.CallableStatement;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;

public abstract class AbstractDialect<T extends AbstractDialect>
implements Dialect {
    private AbstractDialect delegate = null;
    private UrlParser urlParser;
    private LimitHandler limitHandler;
    private LikeEscaper likeEscaper;
    private Boolean isUseLimitInVariableMode = null;
    private final Properties properties = new Properties();

    public AbstractDialect() {
        this.setLimitHandler(new DefaultLimitHandler(this));
        this.setUrlParser(new NoopUrlParser());
        this.setLikeEscaper(BackslashStyleEscaper.NON_DEFAULT_INSTANCE);
    }

    public AbstractDialect(Driver driver) {
        this();
    }

    @Override
    public String getDatabaseId() {
        String name;
        Name nameAnno = (Name)Reflects.getAnnotation(this.getClass(), Name.class);
        if (nameAnno != null) {
            name = nameAnno.value();
            if (Strings.isBlank((String)name)) {
                throw new IllegalStateException("@Name is empty in class" + this.getClass());
            }
        } else {
            String simpleClassName = this.getClass().getSimpleName().toLowerCase();
            name = simpleClassName.replaceAll("dialect", "");
        }
        return name;
    }

    public final Properties getDefaultProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public LimitHandler getLimitHandler() {
        return this.getRealDialect().limitHandler;
    }

    protected void setLimitHandler(LimitHandler limitHandler) {
        limitHandler.setDialect(this);
        this.getRealDialect().limitHandler = limitHandler;
    }

    protected void setDelegate(@Nullable T delegate) {
        this.delegate = delegate;
    }

    protected void setUrlParser(@NonNull UrlParser urlParser) {
        Preconditions.checkNotNull((Object)urlParser);
        if (urlParser instanceof CommonUrlParser) {
            ((CommonUrlParser)urlParser).setDialect(this);
        }
        this.getRealDialect().urlParser = urlParser;
    }

    protected void setLikeEscaper(@NonNull LikeEscaper likeEscaper) {
        this.getRealDialect().likeEscaper = likeEscaper = likeEscaper == null ? BackslashStyleEscaper.INSTANCE : likeEscaper;
    }

    @Override
    public boolean isSupportsLimit() {
        return this.delegate == null ? false : this.delegate.isSupportsLimit();
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return this.delegate == null ? this.isSupportsLimit() : this.delegate.isSupportsLimitOffset();
    }

    @Override
    public boolean isSupportsVariableLimit() {
        return this.delegate == null ? this.isSupportsLimit() : this.delegate.isSupportsVariableLimit();
    }

    @Override
    public void setUseLimitInVariableMode(boolean variableMode) {
        AbstractDialect d = this.getRealDialect();
        d.isUseLimitInVariableMode = d.isSupportsVariableLimit() ? Boolean.valueOf(variableMode) : Boolean.valueOf(false);
    }

    @Override
    public boolean isUseLimitInVariableMode() {
        AbstractDialect d = this.getRealDialect();
        if (d.isUseLimitInVariableMode == null) {
            return d.isSupportsVariableLimit();
        }
        return d.isUseLimitInVariableMode;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return this.delegate == null ? false : this.delegate.isBindLimitParametersInReverseOrder();
    }

    @Override
    public boolean isBindLimitParametersFirst() {
        return this.delegate == null ? false : this.delegate.isBindLimitParametersFirst();
    }

    @Override
    public boolean isUseMaxForLimit() {
        return this.delegate == null ? false : this.delegate.isUseMaxForLimit();
    }

    @Override
    public boolean isForceLimitUsage() {
        return this.delegate == null ? false : this.delegate.isForceLimitUsage();
    }

    protected AbstractDialect getRealDialect() {
        if (this.delegate == null) {
            return this;
        }
        return this.delegate;
    }

    @Override
    public int registerResultSetOutParameter(CallableStatement statement, int position) throws SQLException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support resultsets via stored procedures");
    }

    @Override
    public String getLimitSql(String sql, RowSelection selection) {
        return this.getLimitHandler().processSql(sql, selection);
    }

    @Override
    public void setMaxRows(RowSelection selection, PreparedStatement statement) throws SQLException {
        this.getLimitHandler().setMaxRows(selection, statement);
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return this.getLimitHandler().bindLimitParametersAtEndOfQuery(selection, statement, index);
    }

    @Override
    public int bindLimitParametersAtStartOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return this.getLimitHandler().bindLimitParametersAtStartOfQuery(selection, statement, index);
    }

    @Override
    public UrlParser getUrlParser() {
        return this.getRealDialect().urlParser;
    }

    protected TableGenerator createTableGenerator(DatabaseDescription databaseDescription) {
        return new CommonTableGenerator(databaseDescription, (Dialect)this);
    }

    @Override
    public final String generateTableDDL(@NonNull DatabaseDescription database, String catalog, String schema, @NonNull String tableName) throws SQLException {
        Preconditions.checkNotNull((Object)database);
        Preconditions.checkNotNull((Object)tableName);
        Table table = new DatabaseLoader().loadTable(database, catalog, schema, tableName);
        if (table != null) {
            return this.createTableGenerator(database).generate(table);
        }
        throw new TableNonExistsException(StringTemplates.formatWithPlaceholder((String)"Table {} is not exists", (Object[])new Object[]{SQLs.getTableFQN((DatabaseDescription)database, (String)catalog, (String)schema, (String)tableName)}));
    }

    @Override
    public String getQuotedIdentifier(String identifier) {
        if (identifier == null) {
            return null;
        }
        if (this.delegate == null) {
            identifier = identifier.trim();
            if (!Strings.isBlank((String)("" + this.getBeforeQuote()))) {
                while (identifier.charAt(0) == this.getBeforeQuote()) {
                    identifier = identifier.substring(1);
                }
            }
            if (!Strings.isBlank((String)("" + this.getAfterQuote()))) {
                while (identifier.charAt(identifier.length() - 1) == this.getAfterQuote()) {
                    identifier = identifier.substring(0, identifier.length() - 1);
                }
            }
            return this.getBeforeQuote() + identifier + this.getAfterQuote();
        }
        return this.delegate.getQuotedIdentifier(identifier);
    }

    @Override
    public char getBeforeQuote() {
        return this.delegate == null ? (char)'\"' : this.delegate.getBeforeQuote();
    }

    @Override
    public char getAfterQuote() {
        return this.delegate == null ? (char)'\"' : this.delegate.getAfterQuote();
    }

    @Override
    public boolean isSupportsDistinct() {
        return this.delegate == null ? true : this.delegate.isSupportsDistinct();
    }

    @Override
    public boolean isSupportsBatchUpdates() {
        return this.delegate == null || this.delegate.isSupportsBatchUpdates();
    }

    @Override
    public boolean isSupportsBatchSql() {
        return this.delegate == null || this.delegate.isSupportsBatchSql();
    }

    @Override
    public List<Character> getLikeKeyChars() {
        return this.getRealDialect().likeEscaper.getLikeKeyChars();
    }

    public String escape(String string) {
        return this.getRealDialect().likeEscaper.escape(string);
    }

    @Override
    public String appendmentAfterLikeClause() {
        return this.getRealDialect().likeEscaper.appendmentAfterLikeClause();
    }
}

