/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.langx.util.ClassLoaders;
import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.OffsetFetchFirstOnlyLimitHandler;

public class DerbyDialect
extends AbstractDialect {
    private int driverVersionMajor;
    private int driverVersionMinor;

    public DerbyDialect() {
        this.determineDriverVersion();
        this.setLimitHandler(new OffsetFetchFirstOnlyLimitHandler());
    }

    private void determineDriverVersion() {
        try {
            ClassLoaders.loadClass((String)"org.apache.derby.tools.sysinfo", (ClassLoader)DerbyDialect.class.getClassLoader());
        }
        catch (Exception e) {
            this.driverVersionMajor = -1;
            this.driverVersionMinor = -1;
        }
    }

    private boolean isTenPointFiveReleaseOrNewer() {
        return this.driverVersionMajor > 10 || this.driverVersionMajor == 10 && this.driverVersionMinor >= 5;
    }

    @Override
    public boolean isSupportsLimit() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return this.isTenPointFiveReleaseOrNewer();
    }

    @Override
    public boolean isSupportsVariableLimit() {
        return false;
    }

    @Override
    public boolean isUseMaxForLimit() {
        return true;
    }
}

