/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class IgniteDialect
extends AbstractDialect {
    public IgniteDialect() {
        this.setLimitHandler(new AbstractLimitHandler(){

            @Override
            public String processSql(String sql, RowSelection rowSelection) {
                return null;
            }

            @Override
            protected String getLimitString(String sql, boolean hasOffset) {
                sql = sql.trim();
                String forSampleClause = null;
                boolean isForSample = false;
                int forSampleIndex = sql.toLowerCase(Locale.ROOT).lastIndexOf("sample_size");
                if (forSampleIndex > -1) {
                    forSampleClause = sql.substring(forSampleIndex);
                    sql = sql.substring(0, forSampleIndex - 1);
                    isForSample = true;
                }
                StringBuilder sql2 = new StringBuilder(sql.length() + 100);
                sql2.append(sql);
                if (hasOffset) {
                    sql2.append(" limit ? offset ? ");
                } else {
                    sql2.append(" limit ? ");
                }
                if (isForSample) {
                    sql2.append(forSampleClause);
                }
                return sql2.toString();
            }
        });
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    @Override
    public boolean isBindLimitParametersInReverseOrder() {
        return true;
    }
}

