/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal;

import com.jn.sqlhelper.dialect.internal.AbstractDialect;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.internal.limit.LimitOnlyLimitHandler;
import com.jn.sqlhelper.dialect.pagination.RowSelection;

public class MaxComputeDialect
extends AbstractDialect {
    public MaxComputeDialect() {
        this.setLimitHandler(new LimitOnlyLimitHandler());
    }

    @Override
    public boolean isUseLimitInVariableMode() {
        return true;
    }

    @Override
    public boolean isSupportsLimitOffset() {
        return true;
    }

    @Override
    public boolean isSupportsLimit() {
        return true;
    }

    private static class MaxComputeLimitHandler
    extends AbstractLimitHandler {
        private MaxComputeLimitHandler() {
        }

        @Override
        public String processSql(String sql, RowSelection rowSelection) {
            return this.getLimitString(sql, LimitHelper.getFirstRow(rowSelection), this.getMaxOrLimit(rowSelection));
        }

        @Override
        protected String getLimitString(String sql, long offset, int limit) {
            if (offset == 0L) {
                if (this.getDialect().isUseLimitInVariableMode()) {
                    return sql + " limit ?";
                }
                return sql + " limit " + limit;
            }
            StringBuilder sqlBuilder = new StringBuilder(sql.length() + 256);
            sqlBuilder.append("select * from ( select row_number() over() as sqlhelper_ROW_ID, * from (").append(sql).append(" ) ) sqlhelper_tmp  where sqlhelper_ROW_ID between ? and ?");
            return sqlBuilder.toString();
        }
    }
}

