/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.LimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public abstract class AbstractLimitHandler
extends LimitHandler {
    protected long convertToFirstRowValue(long zeroBasedFirstResult) {
        return zeroBasedFirstResult;
    }

    @Override
    public int bindLimitParametersAtStartOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return this.getDialect().isBindLimitParametersFirst() ? this.bindLimitParameters(selection, statement, index) : 0;
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return !this.getDialect().isBindLimitParametersFirst() ? this.bindLimitParameters(selection, statement, index) : 0;
    }

    @Override
    public void setMaxRows(RowSelection selection, PreparedStatement statement) throws SQLException {
        if (selection.getMaxRows() >= 0) {
            statement.setMaxRows(selection.getMaxRows());
        }
    }

    private int bindLimitParameters(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        if (!this.getDialect().isUseLimitInVariableMode() || !LimitHelper.hasMaxRows(selection)) {
            return 0;
        }
        long firstRow = this.convertToFirstRowValue(LimitHelper.getFirstRow(selection));
        int lastRow = this.getMaxOrLimit(selection);
        boolean hasFirstRow = this.getDialect().isSupportsLimitOffset() && (firstRow > 0L || this.getDialect().isForceLimitUsage());
        boolean reverse = this.getDialect().isBindLimitParametersInReverseOrder();
        if (hasFirstRow) {
            statement.setInt(index + (reverse ? 1 : 0), Long.valueOf(firstRow).intValue());
        }
        statement.setInt(index + (reverse || !hasFirstRow ? 0 : 1), lastRow);
        return hasFirstRow ? 2 : 1;
    }

    protected final int getMaxOrLimit(RowSelection selection) {
        long firstRow = this.convertToFirstRowValue(LimitHelper.getFirstRow(selection));
        int limit = selection.getLimit();
        return this.getDialect().isUseMaxForLimit() ? Long.valueOf((long)limit + firstRow).intValue() : limit;
    }
}

