/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.util.Locale;

public class OffsetFetchFirstOnlyLimitHandler
extends AbstractLimitHandler {
    private boolean isSupportUsingIndexClauseInSelectEnd = false;
    private boolean supportForUpdate = true;
    private boolean supportWithInSelectEnd = true;

    @Override
    public String processSql(String sql, RowSelection rowSelection) {
        return this.getLimitString(sql, rowSelection.getOffset(), this.getMaxOrLimit(rowSelection));
    }

    @Override
    protected String getLimitString(String sql, long offset, int limit) {
        int withClauseIndex;
        int forUpdateIndex;
        boolean hasOffset = offset > 0L;
        sql = sql.trim();
        String forUpdateClause = "";
        boolean isForUpdate = false;
        String sqlLowercase = sql.toLowerCase(Locale.ROOT);
        if (this.isSupportForUpdate() && (forUpdateIndex = sqlLowercase.lastIndexOf("for update")) > -1) {
            forUpdateClause = sql.substring(forUpdateIndex);
            sql = sql.substring(0, forUpdateIndex - 1);
            isForUpdate = true;
        }
        boolean hasWithClause = false;
        String withClause = null;
        if (this.isSupportWithInSelectEnd() && (withClauseIndex = sqlLowercase.lastIndexOf("with ", sqlLowercase.length() - (forUpdateClause.length() + 7))) > 0) {
            sql = sql.substring(0, withClauseIndex - 1);
            hasWithClause = true;
            withClause = sqlLowercase.substring(withClauseIndex);
        }
        boolean hasUsingIndexClause = false;
        String usingIndexClause = null;
        if (this.isSupportUsingIndexClauseInSelectEnd()) {
            int usingIndexIndex = -1;
            usingIndexIndex = sqlLowercase.lastIndexOf("using index", sqlLowercase.length() - 11);
            if (usingIndexIndex > 0) {
                sql = sql.substring(0, usingIndexIndex - 1);
                hasUsingIndexClause = true;
                usingIndexClause = sqlLowercase.substring(usingIndexIndex);
            }
        }
        StringBuilder sql2 = new StringBuilder(sql.length() + 100);
        sql2.append(sql);
        if (this.getDialect().isUseLimitInVariableMode()) {
            if (hasOffset) {
                sql2.append(" OFFSET ? ROWS FETCH NEXT ? ROWS ONLY");
            } else {
                sql2.append(" FETCH FIRST ? ROWS ONLY");
            }
        } else if (hasOffset) {
            sql2.append(" OFFSET " + offset + " ROWS FETCH NEXT " + limit + " ROWS ONLY");
        } else {
            sql2.append(" FETCH FIRST " + limit + " ROWS ONLY");
        }
        if (hasWithClause) {
            sql2.append(withClause);
        } else if (isForUpdate) {
            sql2.append(" " + forUpdateClause);
        } else if (hasUsingIndexClause) {
            sql2.append(" " + usingIndexClause);
        }
        return sql2.toString();
    }

    public boolean isSupportUsingIndexClauseInSelectEnd() {
        return this.isSupportUsingIndexClauseInSelectEnd;
    }

    public OffsetFetchFirstOnlyLimitHandler setSupportUsingIndexClauseInSelectEnd(boolean supportUsingIndexClauseInSelectEnd) {
        this.isSupportUsingIndexClauseInSelectEnd = supportUsingIndexClauseInSelectEnd;
        return this;
    }

    public boolean isSupportForUpdate() {
        return this.supportForUpdate;
    }

    public OffsetFetchFirstOnlyLimitHandler setSupportForUpdate(boolean supportForUpdate) {
        this.supportForUpdate = supportForUpdate;
        return this;
    }

    public boolean isSupportWithInSelectEnd() {
        return this.supportWithInSelectEnd;
    }

    public OffsetFetchFirstOnlyLimitHandler setSupportWithInSelectEnd(boolean supportWithInSelectEnd) {
        this.supportWithInSelectEnd = supportWithInSelectEnd;
        return this;
    }
}

