/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.limit;

import com.jn.langx.util.Strings;
import com.jn.sqlhelper.dialect.internal.limit.AbstractLimitHandler;
import com.jn.sqlhelper.dialect.internal.limit.LimitHelper;
import com.jn.sqlhelper.dialect.pagination.RowSelection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SQLServer2005LimitHandler
extends AbstractLimitHandler {
    private static final Pattern SELECT_DISTINCT_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("select distinct ", true);
    private static final Pattern SELECT_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("select(.*)", true);
    private static final Pattern FROM_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("from", true);
    private static final Pattern DISTINCT_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("distinct", true);
    private static final Pattern ORDER_BY_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern("order by", true);
    private static final Pattern COMMA_PATTERN = SQLServer2005LimitHandler.buildShallowIndexPattern(",", false);
    private static final Pattern ALIAS_PATTERN = Pattern.compile("(?![^\\[]*(\\]))\\S+\\s*(\\s(?i)as\\s)\\s*(\\S+)*\\s*$|(?![^\\[]*(\\]))\\s+(\\S+)$");
    private boolean topAdded;

    @Override
    public long convertToFirstRowValue(long zeroBasedFirstResult) {
        return zeroBasedFirstResult + 1L;
    }

    @Override
    public String processSql(String sql, RowSelection selection) {
        StringBuilder sb = new StringBuilder(sql);
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.setLength(sb.length() - 1);
        }
        if (LimitHelper.hasFirstRow(selection)) {
            String selectClause = this.fillAliasInSelectClause(sb);
            int orderByIndex = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, ORDER_BY_PATTERN, 0);
            if (orderByIndex > 0) {
                this.addTopExpression(sb);
            }
            this.encloseWithOuterQuery(sb);
            sb.insert(0, "WITH query AS (").append(") SELECT ").append(selectClause).append(" FROM query ");
            sb.append("WHERE __sqlhelper_row_nr__ >= ? AND __sqlhelper_row_nr__ < ?");
        } else {
            this.addTopExpression(sb);
        }
        return sb.toString();
    }

    @Override
    public int bindLimitParametersAtStartOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        if (this.topAdded) {
            statement.setInt(index, this.getMaxOrLimit(selection) - 1);
            return 1;
        }
        return 0;
    }

    @Override
    public int bindLimitParametersAtEndOfQuery(RowSelection selection, PreparedStatement statement, int index) throws SQLException {
        return LimitHelper.hasFirstRow(selection) ? super.bindLimitParametersAtEndOfQuery(selection, statement, index) : 0;
    }

    private String fillAliasInSelectClause(StringBuilder sb) {
        String alias;
        String expression;
        String separator = System.getProperty("line.separator");
        LinkedList<String> aliases = new LinkedList<String>();
        int startPos = this.getSelectColumnsStartPosition(sb);
        int endPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, FROM_PATTERN, startPos);
        int nextComa = startPos;
        int prevComa = startPos;
        int unique = 0;
        boolean selectsMultipleColumns = false;
        while (nextComa != -1) {
            prevComa = nextComa;
            if ((nextComa = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, COMMA_PATTERN, nextComa)) > endPos) break;
            if (nextComa == -1) continue;
            expression = sb.substring(prevComa, nextComa);
            if (this.selectsMultipleColumns(expression)) {
                selectsMultipleColumns = true;
            } else {
                alias = this.getAlias(expression);
                if (alias == null) {
                    alias = SQLServer2005LimitHandler.generateAlias("page", unique);
                    sb.insert(nextComa, " as " + alias);
                    int aliasExprLength = (" as " + alias).length();
                    ++unique;
                    nextComa += aliasExprLength;
                    endPos += aliasExprLength;
                }
                aliases.add(alias);
            }
            ++nextComa;
        }
        if (this.selectsMultipleColumns(expression = sb.substring(prevComa, endPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sb, FROM_PATTERN, startPos)))) {
            selectsMultipleColumns = true;
        } else {
            alias = this.getAlias(expression);
            if (alias == null) {
                alias = SQLServer2005LimitHandler.generateAlias("page", unique);
                boolean endWithSeparator = sb.substring(endPos - separator.length()).startsWith(separator);
                sb.insert(endPos - (endWithSeparator ? 2 : 1), " as " + alias);
            }
            aliases.add(alias);
        }
        return selectsMultipleColumns ? "*" : Strings.join((String)", ", aliases.iterator());
    }

    private static String replace(String template, String placeholder, String replacement, boolean wholeWords, boolean encloseInParensIfNecessary) {
        if (template == null) {
            return null;
        }
        int loc = template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        String beforePlaceholder = template.substring(0, loc);
        String afterPlaceholder = template.substring(loc + placeholder.length());
        return SQLServer2005LimitHandler.replace(beforePlaceholder, afterPlaceholder, placeholder, replacement, wholeWords, encloseInParensIfNecessary);
    }

    private static String replace(String beforePlaceholder, String afterPlaceholder, String placeholder, String replacement, boolean wholeWords, boolean encloseInParensIfNecessary) {
        boolean actuallyReplace = !wholeWords || afterPlaceholder.length() == 0 || !Character.isJavaIdentifierPart(afterPlaceholder.charAt(0));
        boolean encloseInParens = actuallyReplace && encloseInParensIfNecessary && SQLServer2005LimitHandler.getLastNonWhitespaceCharacter(beforePlaceholder) != '(' && (SQLServer2005LimitHandler.getLastNonWhitespaceCharacter(beforePlaceholder) != ',' || SQLServer2005LimitHandler.getFirstNonWhitespaceCharacter(afterPlaceholder) != ')');
        StringBuilder buf = new StringBuilder(beforePlaceholder);
        if (encloseInParens) {
            buf.append('(');
        }
        buf.append(actuallyReplace ? replacement : placeholder);
        if (encloseInParens) {
            buf.append(')');
        }
        buf.append(SQLServer2005LimitHandler.replace(afterPlaceholder, placeholder, replacement, wholeWords, encloseInParensIfNecessary));
        return buf.toString();
    }

    private static char getLastNonWhitespaceCharacter(String str) {
        if (str != null && str.length() > 0) {
            for (int i = str.length() - 1; i >= 0; --i) {
                char ch = str.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                return ch;
            }
        }
        return '\u0000';
    }

    private static char getFirstNonWhitespaceCharacter(String str) {
        if (str != null && str.length() > 0) {
            for (int i = 0; i < str.length(); ++i) {
                char ch = str.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                return ch;
            }
        }
        return '\u0000';
    }

    private static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(46);
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1);
    }

    private static String generateAlias(String description, int unique) {
        return SQLServer2005LimitHandler.generateAliasRoot(description) + Integer.toString(unique) + '_';
    }

    private static String generateAliasRoot(String description) {
        String result = Strings.truncate((String)SQLServer2005LimitHandler.unqualifyEntityName(description), (int)10).toLowerCase(Locale.ROOT).replace('/', '_').replace('$', '_');
        if (Character.isDigit((result = SQLServer2005LimitHandler.cleanAlias(result)).charAt(result.length() - 1))) {
            return result + "x";
        }
        return result;
    }

    private static String cleanAlias(String alias) {
        char[] chars = alias.toCharArray();
        if (!Character.isLetter(chars[0])) {
            for (int i = 1; i < chars.length; ++i) {
                if (!Character.isLetter(chars[i])) continue;
                return alias.substring(i);
            }
        }
        return alias;
    }

    private static String unqualifyEntityName(String entityName) {
        String result = SQLServer2005LimitHandler.unqualify(entityName);
        int slashPos = result.indexOf(47);
        if (slashPos > 0) {
            result = result.substring(0, slashPos - 1);
        }
        return result;
    }

    private int getSelectColumnsStartPosition(StringBuilder sb) {
        int startPos = this.getSelectStartPosition(sb);
        String sql = sb.toString().substring(startPos).toLowerCase();
        if (sql.startsWith("select distinct ")) {
            return startPos + "select distinct ".length();
        }
        if (sql.startsWith("select ")) {
            return startPos + "select ".length();
        }
        return startPos;
    }

    private int getSelectStartPosition(StringBuilder sb) {
        return SQLServer2005LimitHandler.shallowIndexOfPattern(sb, SELECT_PATTERN, 0);
    }

    private boolean selectsMultipleColumns(String expression) {
        String lastExpr = expression.trim().replaceFirst("(?i)(.)*\\s", "").trim();
        return "*".equals(lastExpr) || lastExpr.endsWith(".*");
    }

    private String getAlias(String expression) {
        expression = expression.replaceFirst("(\\((.)*\\))", "").trim();
        Matcher matcher = ALIAS_PATTERN.matcher(expression);
        String alias = null;
        if (matcher.find() && matcher.groupCount() > 1 && (alias = matcher.group(3)) == null) {
            alias = matcher.group(0);
        }
        return alias != null ? alias.trim() : null;
    }

    private void encloseWithOuterQuery(StringBuilder sql) {
        sql.insert(0, "SELECT inner_query.*, ROW_NUMBER() OVER (ORDER BY CURRENT_TIMESTAMP) as __sqlhelper_row_nr__ FROM ( ");
        sql.append(" ) inner_query ");
    }

    private void addTopExpression(StringBuilder sql) {
        int selectDistinctPos;
        int selectPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sql, SELECT_PATTERN, 0);
        if (selectPos == (selectDistinctPos = SQLServer2005LimitHandler.shallowIndexOfPattern(sql, SELECT_DISTINCT_PATTERN, 0))) {
            sql.insert(selectDistinctPos + "select distinct".length(), " TOP(?)");
        } else {
            sql.insert(selectPos + "select".length(), " TOP(?)");
        }
        this.topAdded = true;
    }

    private static int shallowIndexOfPattern(StringBuilder sb, Pattern pattern, int fromIndex) {
        int index;
        block3: {
            Matcher matcher;
            List<IgnoreRange> ignoreRangeList;
            block2: {
                index = -1;
                String matchString = sb.toString();
                if (matchString.length() < fromIndex || fromIndex < 0) {
                    return -1;
                }
                ignoreRangeList = SQLServer2005LimitHandler.generateIgnoreRanges(matchString);
                matcher = pattern.matcher(matchString);
                matcher.region(fromIndex, matchString.length());
                if (!ignoreRangeList.isEmpty()) break block2;
                if (!matcher.find() || matcher.groupCount() <= 0) break block3;
                index = matcher.start();
                break block3;
            }
            while (matcher.find() && matcher.groupCount() > 0) {
                int position = matcher.start();
                if (SQLServer2005LimitHandler.isPositionIgnorable(ignoreRangeList, position)) continue;
                index = position;
                break;
            }
        }
        return index;
    }

    private static Pattern buildShallowIndexPattern(String pattern, boolean wordBoundardy) {
        return Pattern.compile("(" + (wordBoundardy ? "\\b" : "") + pattern + ")(?![^\\(|\\[]*(\\)|\\]))", 2);
    }

    private static List<IgnoreRange> generateIgnoreRanges(String sql) {
        ArrayList<IgnoreRange> ignoreRangeList = new ArrayList<IgnoreRange>();
        int depth = 0;
        int start = -1;
        for (int i = 0; i < sql.length(); ++i) {
            char ch = sql.charAt(i);
            if (ch == '(') {
                if (++depth != 1) continue;
                start = i;
                continue;
            }
            if (ch != ')') continue;
            if (depth > 0) {
                if (depth == 1) {
                    ignoreRangeList.add(new IgnoreRange(start, i));
                    start = -1;
                }
                --depth;
                continue;
            }
            throw new IllegalStateException("Found an unmatched ')' at position " + i + ": " + sql);
        }
        if (depth != 0) {
            throw new IllegalStateException("Unmatched parenthesis in rendered SQL (" + depth + " depth): " + sql);
        }
        return ignoreRangeList;
    }

    private static boolean isPositionIgnorable(List<IgnoreRange> ignoreRangeList, int position) {
        for (IgnoreRange ignoreRange : ignoreRangeList) {
            if (!ignoreRange.isWithinRange(position)) continue;
            return true;
        }
        return false;
    }

    static class IgnoreRange {
        private int start;
        private int end;

        IgnoreRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        boolean isWithinRange(int position) {
            return position >= this.start && position <= this.end;
        }
    }
}

