/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.StringMaker;
import com.jn.sqlhelper.dialect.internal.urlparser.CommonUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.DefaultDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UnKnownDatabaseInfo;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MariaDBUrlParser
extends CommonUrlParser {
    private static final String URL_PREFIX = "jdbc:mariadb:";
    private static final String MYSQL_URL_PREFIX = "jdbc:mysql:";
    private static final Logger logger = LoggerFactory.getLogger(MariaDBUrlParser.class);
    private static final List<String> URL_SCHEMAS = Arrays.asList("jdbc:mariadb:");

    @Override
    public List<String> getUrlSchemas() {
        return URL_SCHEMAS;
    }

    private DatabaseInfo parse0(String url, Type type) {
        if (this.isLoadbalanceUrl(url, type)) {
            return this.parseLoadbalancedUrl(url, type);
        }
        return this.parseNormal(url, type);
    }

    private boolean isLoadbalanceUrl(String url, Type type) {
        String loadbalanceUrlPrefix = type.getLoadbalanceUrlPrefix();
        return url.regionMatches(true, 0, loadbalanceUrlPrefix, 0, loadbalanceUrlPrefix.length());
    }

    private DatabaseInfo parseLoadbalancedUrl(String url, Type type) {
        StringMaker maker = new StringMaker(url);
        maker.after(type.getUrlPrefix());
        String host = maker.after("//").before('/').value();
        String[] parsedHost = host.split(",");
        List<String> hostList = Arrays.asList(parsedHost);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo("mariadb", url, normalizedUrl, hostList, databaseId);
    }

    private DatabaseInfo parseNormal(String url, Type type) {
        StringMaker maker = new StringMaker(url);
        maker.after(type.getUrlPrefix());
        String host = maker.after("//").before('/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo("mariadb", url, normalizedUrl, hostList, databaseId);
    }

    @Override
    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            logger.info("jdbcUrl may not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        Type type = Type.findType(jdbcUrl);
        if (type == null) {
            logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{}, {})", new Object[]{jdbcUrl, URL_PREFIX, MYSQL_URL_PREFIX});
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl, type);
        }
        catch (Exception e) {
            logger.info("MaridDBJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase("mariadb", jdbcUrl);
        }
        return result;
    }

    public static enum Type {
        MARIA("jdbc:mariadb:"),
        MYSQL("jdbc:mysql:");

        private final String urlPrefix;
        private final String loadbalanceUrlPrefix;

        private Type(String urlPrefix) {
            this.urlPrefix = urlPrefix;
            this.loadbalanceUrlPrefix = urlPrefix + "loadbalance:";
        }

        private String getUrlPrefix() {
            return this.urlPrefix;
        }

        private String getLoadbalanceUrlPrefix() {
            return this.urlPrefix + "loadbalance:";
        }

        public static Type findType(String jdbcUrl) {
            for (Type type : Type.values()) {
                if (!jdbcUrl.startsWith(type.urlPrefix)) continue;
                return type;
            }
            return null;
        }
    }
}

