/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.StringMaker;
import com.jn.sqlhelper.dialect.internal.urlparser.CommonUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.DefaultDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UnKnownDatabaseInfo;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlUrlParser
extends CommonUrlParser {
    private static final String URL_PREFIX = "jdbc:mysql:";
    private static final String LOADBALANCE_URL_PREFIX = "jdbc:mysql:loadbalance:";
    private static final Logger logger = LoggerFactory.getLogger(MySqlUrlParser.class);
    private static final List<String> URL_SCHEMAS = Arrays.asList("jdbc:mysql:");

    @Override
    public List<String> getUrlSchemas() {
        return URL_SCHEMAS;
    }

    @Override
    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            logger.info("jdbcUrl may not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        if (!jdbcUrl.startsWith(URL_PREFIX)) {
            logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)URL_PREFIX);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            logger.info("MySqlJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase("mysql", jdbcUrl);
        }
        return result;
    }

    private DatabaseInfo parse0(String jdbcUrl) {
        if (this.isLoadbalanceUrl(jdbcUrl)) {
            return this.parseLoadbalancedUrl(jdbcUrl);
        }
        return this.parseNormal(jdbcUrl);
    }

    private boolean isLoadbalanceUrl(String jdbcUrl) {
        return jdbcUrl.regionMatches(true, 0, LOADBALANCE_URL_PREFIX, 0, LOADBALANCE_URL_PREFIX.length());
    }

    private DatabaseInfo parseLoadbalancedUrl(String jdbcUrl) {
        StringMaker maker = new StringMaker(jdbcUrl);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        String[] parsedHost = host.split(",");
        List<String> hostList = Arrays.asList(parsedHost);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo("mysql", jdbcUrl, normalizedUrl, hostList, databaseId);
    }

    private DatabaseInfo parseNormal(String jdbcUrl) {
        StringMaker maker = new StringMaker(jdbcUrl);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo("mysql", jdbcUrl, normalizedUrl, hostList, databaseId);
    }
}

