/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.internal.urlparser;

import com.jn.langx.util.StringMaker;
import com.jn.sqlhelper.dialect.internal.urlparser.CommonUrlParser;
import com.jn.sqlhelper.dialect.internal.urlparser.DefaultDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UnKnownDatabaseInfo;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLUrlParser
extends CommonUrlParser {
    private static final String URL_PREFIX = "jdbc:postgresql:";
    private static final String LOADBALANCE_URL_PREFIX = "jdbc:postgresql:loadbalance:";
    private static final Logger logger = LoggerFactory.getLogger(PostgreSQLUrlParser.class);
    private static final List<String> URL_SCHEMAS = Arrays.asList("jdbc:postgresql:");

    @Override
    public List<String> getUrlSchemas() {
        return URL_SCHEMAS;
    }

    @Override
    public DatabaseInfo parse(String jdbcUrl) {
        if (jdbcUrl == null) {
            logger.info("jdbcUrl may not be null");
            return UnKnownDatabaseInfo.INSTANCE;
        }
        if (!jdbcUrl.startsWith(URL_PREFIX)) {
            logger.info("jdbcUrl has invalid prefix.(url:{}, prefix:{})", (Object)jdbcUrl, (Object)URL_PREFIX);
            return UnKnownDatabaseInfo.INSTANCE;
        }
        DatabaseInfo result = null;
        try {
            result = this.parse0(jdbcUrl);
        }
        catch (Exception e) {
            logger.info("PostgreJdbcUrl parse error. url: {}, Caused: {}", new Object[]{jdbcUrl, e.getMessage(), e});
            result = UnKnownDatabaseInfo.createUnknownDataBase("postgresql", jdbcUrl);
        }
        return result;
    }

    private DatabaseInfo parse0(String url) {
        if (this.isLoadbalanceUrl(url)) {
            return this.parseLoadbalancedUrl(url);
        }
        return this.parseNormal(url);
    }

    private DatabaseInfo parseLoadbalancedUrl(String url) {
        StringMaker maker = new StringMaker(url);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        String[] parsedHost = host.split(",");
        List<String> hostList = Arrays.asList(parsedHost);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo("postgresql", url, normalizedUrl, hostList, databaseId);
    }

    private boolean isLoadbalanceUrl(String url) {
        return url.regionMatches(true, 0, LOADBALANCE_URL_PREFIX, 0, LOADBALANCE_URL_PREFIX.length());
    }

    private DatabaseInfo parseNormal(String url) {
        StringMaker maker = new StringMaker(url);
        maker.after(URL_PREFIX);
        String host = maker.after("//").before('/').value();
        ArrayList<String> hostList = new ArrayList<String>(1);
        hostList.add(host);
        String databaseId = maker.next().afterLast('/').before('?').value();
        String normalizedUrl = maker.clear().before('?').value();
        return new DefaultDatabaseInfo("postgresql", url, normalizedUrl, hostList, databaseId);
    }
}

