/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.orderby;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.function.Function;
import com.jn.sqlhelper.dialect.orderby.OrderByItem;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class OrderBy
implements Serializable,
Iterable<OrderByItem> {
    public static final OrderBy EMPTY = new OrderBy();
    private final Map<String, OrderByItem> items = new LinkedHashMap<String, OrderByItem>();

    public boolean isValid() {
        return !this.items.isEmpty();
    }

    public void add(OrderByItem item) {
        this.items.put(item.getExpression(), item);
    }

    public void addAll(Collection<OrderByItem> items) {
        for (OrderByItem item : items) {
            this.add(item);
        }
    }

    public void addAsc(String expression) {
        this.add(new OrderByItem(expression, true));
    }

    public void addDesc(String expression) {
        this.add(new OrderByItem(expression, false));
    }

    @Override
    @NonNull
    public Iterator<OrderByItem> iterator() {
        return this.items.values().iterator();
    }

    public String toString() {
        return Strings.join((String)",", (Iterable)Pipeline.of(this.items.values()).map((Function)new Function<OrderByItem, String>(){

            public String apply(OrderByItem item) {
                return item.toString();
            }
        }).getAll());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OrderBy that = (OrderBy)object;
        return this.toString().equalsIgnoreCase(that.toString());
    }

    public int hashCode() {
        return Pipeline.of(this.items.values()).map((Function)new Function<OrderByItem, Integer>(){

            public Integer apply(OrderByItem item) {
                return item.hashCode();
            }
        }).sum().intValue();
    }

    public void setComparator(String itemExpression, Comparator comparator) {
        OrderByItem item = this.items.get(itemExpression);
        if (item != null) {
            item.setComparator(comparator);
        }
    }
}

