/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.orderby;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Function;
import com.jn.sqlhelper.common.symbolmapper.NoopSymbolMapper;
import com.jn.sqlhelper.common.symbolmapper.SqlSymbolMapper;
import com.jn.sqlhelper.dialect.orderby.OrderBy;
import com.jn.sqlhelper.dialect.orderby.OrderByBuilder;
import com.jn.sqlhelper.dialect.orderby.OrderByItem;
import com.jn.sqlhelper.dialect.orderby.OrderByType;
import java.util.Comparator;
import java.util.List;

public class ProgramStyleOrderByBuilder
implements OrderByBuilder<Object> {
    private List<OrderByItem> orderByItems = Collects.emptyArrayList();
    private OrderByItem currentItem;
    private SqlSymbolMapper sqlSymbolMapper = NoopSymbolMapper.DEFAULT;

    public ProgramStyleOrderByBuilder sqlSymbolMapper(SqlSymbolMapper symbolMapper) {
        if (symbolMapper != null) {
            this.sqlSymbolMapper = symbolMapper;
        }
        return this;
    }

    public ProgramStyleOrderByBuilder column(String column) {
        Preconditions.checkNotNull((Object)column);
        if (this.currentItem == null) {
            this.currentItem = new OrderByItem(column);
            this.currentItem.setType(OrderByType.ASC);
            this.orderByItems.add(this.currentItem);
            return this;
        }
        if (!column.equalsIgnoreCase(this.currentItem.getExpression())) {
            this.currentItem = null;
            this.column(column);
        }
        return this;
    }

    private ProgramStyleOrderByBuilder order(@Nullable OrderByType orderByType, @Nullable Comparator comparator) {
        orderByType = orderByType == null ? OrderByType.ASC : orderByType;
        Preconditions.checkNotNull((Object)this.currentItem, (String)"you should set which column to order first");
        this.currentItem.setType(orderByType);
        this.currentItem.setComparator(comparator);
        return this;
    }

    public ProgramStyleOrderByBuilder column(String column, OrderByType orderByType) {
        return this.column(column, orderByType, null);
    }

    public ProgramStyleOrderByBuilder column(String column, OrderByType orderByType, Comparator comparator) {
        this.column(column);
        return this.order(orderByType, comparator);
    }

    public ProgramStyleOrderByBuilder asc(String column) {
        return this.column(column, OrderByType.ASC);
    }

    public ProgramStyleOrderByBuilder desc(String column) {
        return this.column(column, OrderByType.DESC);
    }

    public OrderBy build() {
        return this.build((Object)null);
    }

    @Override
    public OrderBy build(Object object) {
        OrderBy orderBy = new OrderBy();
        orderBy.addAll(Collects.map(this.orderByItems, (Function)new Function<OrderByItem, OrderByItem>(){

            public OrderByItem apply(OrderByItem item) {
                item.setExpression((String)ProgramStyleOrderByBuilder.this.sqlSymbolMapper.apply((Object)item.getExpression()));
                return item;
            }
        }));
        return orderBy;
    }
}

