/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.pagination;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.sqlhelper.dialect.SqlRequests;
import com.jn.sqlhelper.dialect.instrument.SQLStatementInstrumentor;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;

public class SqlPaginations
extends SqlRequests {
    public static String extractBeforeSubqueryPartition(@NonNull String sql, @NonNull String startFlag) {
        Preconditions.checkNotNull((Object)startFlag, (String)StringTemplates.formatWithPlaceholder((String)"The start flag of the subquery paging request is invalid: {}", (Object[])new Object[]{startFlag}));
        int index = sql.indexOf(startFlag);
        if (index != -1) {
            return sql.substring(0, index);
        }
        return null;
    }

    public static String extractSubqueryPartition(@NonNull String sql, @NonNull String startFlag, @NonNull String endFlag) {
        Preconditions.checkNotNull((Object)startFlag, (String)StringTemplates.formatWithPlaceholder((String)"The start flag of the subquery paging request is invalid: {}", (Object[])new Object[]{startFlag}));
        Preconditions.checkNotNull((Object)endFlag, (String)StringTemplates.formatWithPlaceholder((String)"The   end flag of the subquery paging request is invalid: {}", (Object[])new Object[]{endFlag}));
        String subquery = null;
        int index = sql.indexOf(startFlag);
        if (index != -1) {
            subquery = sql.substring(index + startFlag.length());
        }
        if (Objects.nonNull(subquery) && (index = subquery.lastIndexOf(endFlag)) != -1) {
            subquery = subquery.substring(0, index);
        }
        return subquery;
    }

    public static String extractAfterSubqueryPartition(@NonNull String sql, @NonNull String endFlag) {
        Preconditions.checkNotNull((Object)endFlag, (String)StringTemplates.formatWithPlaceholder((String)"The   end flag of the subquery paging request is invalid: {}", (Object[])new Object[]{endFlag}));
        int index = sql.lastIndexOf(endFlag);
        if (index != -1) {
            return sql.substring(index + endFlag.length());
        }
        return null;
    }

    public static boolean isSubqueryPagingRequest(@Nullable PagingRequest request) {
        if (Objects.isNull((Object)request)) {
            return false;
        }
        return request.isSubqueryPaging();
    }

    public static boolean isValidSubQueryPagination(@Nullable PagingRequest request, @NonNull SQLStatementInstrumentor instrumentor) {
        if (!SqlPaginations.isSubqueryPagingRequest(request)) {
            return false;
        }
        return Strings.isNotBlank((String)SqlPaginations.getSubqueryPaginationStartFlag(request, instrumentor)) && Strings.isNotBlank((String)SqlPaginations.getSubqueryPaginationEndFlag(request, instrumentor));
    }

    public static String getSubqueryPaginationStartFlag(@Nullable PagingRequest request) {
        if (Objects.isNull((Object)request)) {
            return null;
        }
        String flag = request.getSubqueryPagingStartFlag();
        if (Strings.isNotBlank((String)flag)) {
            return flag;
        }
        return null;
    }

    public static String getSubqueryPaginationStartFlag(@Nullable PagingRequest request, @NonNull SQLStatementInstrumentor instrumentor) {
        String flag = SqlPaginations.getSubqueryPaginationStartFlag(request);
        if (Strings.isNotBlank((String)flag)) {
            return flag;
        }
        return instrumentor.getConfig().getSubqueryPagingStartFlag();
    }

    public static String getSubqueryPaginationEndFlag(@Nullable PagingRequest request) {
        if (Objects.isNull((Object)request)) {
            return null;
        }
        String flag = request.getSubqueryPagingEndFlag();
        if (Strings.isNotBlank((String)flag)) {
            return flag;
        }
        return null;
    }

    public static String getSubqueryPaginationEndFlag(@Nullable PagingRequest request, @NonNull SQLStatementInstrumentor instrumentor) {
        String flag = SqlPaginations.getSubqueryPaginationEndFlag(request);
        if (Strings.isNotBlank((String)flag)) {
            return flag;
        }
        return instrumentor.getConfig().getSubqueryPagingEndFlag();
    }
}

