/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.dialect.urlparser;

import com.jn.langx.util.Objects;
import com.jn.langx.util.Preconditions;
import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.DialectRegistry;
import com.jn.sqlhelper.dialect.internal.urlparser.UnKnownDatabaseInfo;
import com.jn.sqlhelper.dialect.internal.urlparser.UrlParser;
import com.jn.sqlhelper.dialect.urlparser.DatabaseInfo;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcUrlParser {
    private static final Logger logger = LoggerFactory.getLogger(JdbcUrlParser.class);
    private DialectRegistry dialectRegistry = DialectRegistry.getInstance();

    public DatabaseInfo parse(String url) {
        Preconditions.checkNotNull((Object)url);
        Collection<Dialect> dialects = this.dialectRegistry.getDialects();
        UrlParser parser = null;
        block2: for (Dialect dialect : dialects) {
            if (!Objects.isNotNull((Object)dialect.getUrlParser())) continue;
            for (String schema : dialect.getUrlParser().getUrlSchemas()) {
                if (!url.startsWith(schema)) continue;
                parser = dialect.getUrlParser();
                continue block2;
            }
        }
        if (parser != null) {
            try {
                return parser.parse(url);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                return UnKnownDatabaseInfo.createUnknownDataBase(url);
            }
        }
        return UnKnownDatabaseInfo.createUnknownDataBase(url);
    }
}

