/*
 * Decompiled with CFR 0.152.
 */
package com.github.fangjinuo.sqlhelper.ebean;

import com.github.fangjinuo.sqlhelper.dialect.Dialect;
import com.github.fangjinuo.sqlhelper.dialect.DialectRegistry;
import com.github.fangjinuo.sqlhelper.dialect.RowSelection;
import com.github.fangjinuo.sqlhelper.dialect.SQLStatementInstrumentor;
import com.github.fangjinuo.sqlhelper.dialect.conf.SQLInstrumentConfig;
import com.github.fangjinuo.sqlhelper.dialect.internal.AbstractDialect;
import com.github.fangjinuo.sqlhelper.dialect.internal.limit.OracleXLimitHandler;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.LimitOffsetSqlLimiter;
import io.ebean.config.dbplatform.SqlLimitRequest;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.config.dbplatform.SqlLimiter;

public class EBeanCommonSqlLimiter
implements SqlLimiter {
    private SQLStatementInstrumentor instrumentor;
    private SqlLimiter ebeanDefaultSqlLimiter = new LimitOffsetSqlLimiter();

    public SQLStatementInstrumentor getInstrumentor() {
        return this.instrumentor;
    }

    public void setInstrumentor(SQLStatementInstrumentor instrumentor) {
        this.instrumentor = instrumentor;
    }

    private String findDatabaseId(DatabasePlatform databasePlatform) {
        String databaseId = DialectRegistry.guessDatabaseId((String)databasePlatform.getPlatform().name());
        if (databaseId != null) {
            if (this.instrumentor.getConfig() == null) {
                this.instrumentor.setConfig(new SQLInstrumentConfig());
            }
            this.instrumentor.getConfig().setDialect(databaseId);
        }
        if (databaseId == null && this.instrumentor.getConfig() != null) {
            return this.instrumentor.getConfig().getDialect();
        }
        return databaseId;
    }

    public SqlLimitResponse limit(SqlLimitRequest request) {
        String databaseId = this.findDatabaseId(request.getDbPlatform());
        if (databaseId == null || !this.instrumentor.beginIfSupportsLimit(databaseId)) {
            return this.ebeanDefaultSqlLimiter.limit(request);
        }
        Dialect dialect = DialectRegistry.getInstance().getDialectByName(databaseId);
        dialect.setUseLimitInVariableMode(false);
        String dbSql = request.getDbSql();
        StringBuilder sb = new StringBuilder(50 + dbSql.length());
        sb.append("select ");
        if (dialect.isSupportsDistinct() && request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(dbSql);
        RowSelection rowSelection = new RowSelection();
        rowSelection.setOffset(Integer.valueOf(request.getFirstRow()));
        rowSelection.setLimit(Integer.valueOf(request.getMaxRows()));
        String sql = this.instrumentor.instrumentSql(dialect, sb.toString(), rowSelection);
        sql = request.getDbPlatform().completeSql(sql, request.getOrmQuery());
        boolean needRowNo = false;
        if (dialect instanceof AbstractDialect) {
            needRowNo = ((AbstractDialect)dialect).getLimitHandler() instanceof OracleXLimitHandler;
        }
        return new SqlLimitResponse(sql, needRowNo);
    }
}

