/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.ebean;

import com.jn.sqlhelper.dialect.Dialect;
import com.jn.sqlhelper.dialect.DialectRegistry;
import com.jn.sqlhelper.dialect.SQLStatementInstrumentor;
import com.jn.sqlhelper.dialect.conf.SQLInstrumentConfig;
import com.jn.sqlhelper.ebean.EBeanCommonSqlLimiter;
import io.ebean.config.AutoConfigure;
import io.ebean.config.ServerConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.datasource.DataSourceConfig;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlLimiterAutoConfigure
implements AutoConfigure {
    private static final Logger logger = LoggerFactory.getLogger(SqlLimiterAutoConfigure.class);

    public void preConfigure(ServerConfig serverConfig) {
    }

    public void postConfigure(ServerConfig serverConfig) {
        DataSourceConfig dataSourceConfig;
        Field field = null;
        try {
            field = DatabasePlatform.class.getDeclaredField("sqlLimiter");
            field.setAccessible(true);
        }
        catch (Throwable ex) {
            logger.warn("Can't find field [{}] in class {}", (Object)"sqlLimiter", (Object)DatabasePlatform.class.getCanonicalName());
        }
        if (field == null) {
            return;
        }
        SQLStatementInstrumentor instrumentor = new SQLStatementInstrumentor();
        SQLInstrumentConfig instrumentConfig = null;
        String databaseId = null;
        String databaseName = serverConfig.getDatabasePlatformName();
        if (databaseName != null) {
            databaseId = DialectRegistry.guessDatabaseId((String)databaseName);
        }
        if (databaseId == null && (databaseId = DialectRegistry.guessDatabaseId((String)(dataSourceConfig = serverConfig.getDataSourceConfig()).getDriver())) == null) {
            databaseId = DialectRegistry.guessDatabaseId((String)dataSourceConfig.getUrl());
        }
        if (databaseId != null) {
            instrumentConfig = new SQLInstrumentConfig();
            instrumentConfig.setDialect(databaseId);
        }
        if (instrumentConfig != null) {
            instrumentor.setConfig(instrumentConfig);
        }
        EBeanCommonSqlLimiter commonSqlLimiter = new EBeanCommonSqlLimiter();
        commonSqlLimiter.setInstrumentor(instrumentor);
        DatabasePlatform databasePlatform = serverConfig.getDatabasePlatform();
        try {
            field.set(databasePlatform, commonSqlLimiter);
        }
        catch (Throwable ex) {
            logger.warn("Configure a common SqlLimit [{}] for EBean fail,", (Object)EBeanCommonSqlLimiter.class.getCanonicalName());
        }
        if (databaseId != null) {
            try {
                Dialect dialect = DialectRegistry.getInstance().getDialectByName(databaseId);
                Field openQuote = DatabasePlatform.class.getDeclaredField("openQuote");
                openQuote.setAccessible(true);
                Field closeQuote = DatabasePlatform.class.getDeclaredField("closeQuote");
                openQuote.setAccessible(true);
                openQuote.set(databasePlatform, "" + dialect.getBeforeQuote());
                closeQuote.set(databasePlatform, "" + dialect.getAfterQuote());
            }
            catch (Throwable ex) {
                logger.warn("Set openQuote, closeQuote fail for databaseId {}", (Object)databaseId);
            }
        }
    }
}

