/*
 * Decompiled with CFR 0.152.
 */
package com.github.fangjinuo.sqlhelper.examples.common.controller;

import com.github.fangjinuo.sqlhelper.dialect.pagination.PagingRequest;
import com.github.fangjinuo.sqlhelper.dialect.pagination.PagingRequestContextHolder;
import com.github.fangjinuo.sqlhelper.dialect.pagination.PagingResult;
import com.github.fangjinuo.sqlhelper.examples.common.dao.UserDao;
import com.github.fangjinuo.sqlhelper.examples.common.model.User;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping(value={"/users"})
public class UserController {
    private UserDao userDao;

    @Autowired
    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @PostMapping
    public void add(User user) {
        this.userDao.insert(user);
    }

    @PutMapping(value={"/{id}"})
    public void update(String id, User user) {
        user.setId(id);
        User u = this.userDao.selectById(id);
        if (u == null) {
            this.add(user);
        } else {
            this.userDao.updateById(user);
        }
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteById(@RequestParam(value="id") String id) {
        this.userDao.deleteById(id);
    }

    @GetMapping
    public PagingResult list() {
        User queryCondtion = new User();
        queryCondtion.setAge(10);
        PagingRequest request = new PagingRequest().setPageNo(1).setPageSize(10);
        PagingRequestContextHolder.getContext().setPagingRequest(request);
        List<User> users = this.userDao.selectByLimit(queryCondtion);
        request.getResult().setItems(users);
        return request.getResult();
    }

    @GetMapping(value={"/{id}"})
    public User getById(@RequestParam(value="id") String id) {
        return this.userDao.selectById(id);
    }
}

