/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.examples.common.controller;

import com.jn.easyjson.core.JSONBuilderProvider;
import com.jn.sqlhelper.dialect.orderby.SqlStyleOrderByBuilder;
import com.jn.sqlhelper.dialect.pagination.PagingRequest;
import com.jn.sqlhelper.dialect.pagination.PagingRequestContextHolder;
import com.jn.sqlhelper.dialect.pagination.PagingResult;
import com.jn.sqlhelper.examples.common.dao.UserDao;
import com.jn.sqlhelper.examples.common.model.User;
import com.jn.sqlhelper.springjdbc.JdbcTemplate;
import io.swagger.annotations.Api;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api
@RestController
@RequestMapping(value={"/users"})
public class UserController {
    private UserDao userDao;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Autowired
    public void setUserDao(UserDao userDao) {
        this.userDao = userDao;
    }

    @PostMapping
    public void add(User user) {
        this.userDao.insert(user);
    }

    @PutMapping(value={"/{id}"})
    public void update(String id, User user) {
        user.setId(id);
        User u = this.userDao.selectById(id);
        if (u == null) {
            this.add(user);
        } else {
            this.userDao.updateById(user);
        }
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteById(@RequestParam(value="id") String id) {
        this.userDao.deleteById(id);
    }

    @GetMapping(value={"/_useMyBatis"})
    public PagingResult list_useMyBatis(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="sort", required=false) String sort) {
        User queryCondtion = new User();
        queryCondtion.setAge(10);
        PagingRequest request = new PagingRequest().limit(pageNo == null ? 1 : pageNo, pageSize == null ? -1 : pageSize).setOrderBy(SqlStyleOrderByBuilder.DEFAULT.build(sort));
        PagingRequestContextHolder.getContext().setPagingRequest(request);
        List<User> users = this.userDao.selectByLimit(queryCondtion);
        String json = JSONBuilderProvider.simplest().toJson((Object)request.getResult());
        System.out.println(json);
        json = JSONBuilderProvider.simplest().toJson(users);
        System.out.println(json);
        return request.getResult();
    }

    @GetMapping(value={"/_useSpringJdbc_rowMapper"})
    public PagingResult list_useSpringJdbc_rowMapper(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="sort", required=false) String sort) {
        User queryCondtion = new User();
        queryCondtion.setAge(10);
        PagingRequest request = new PagingRequest().limit(pageNo == null ? 1 : pageNo, pageSize == null ? -1 : pageSize).setOrderBy(SqlStyleOrderByBuilder.DEFAULT.build(sort));
        PagingRequestContextHolder.getContext().setPagingRequest(request);
        StringBuilder sqlBuilder = new StringBuilder("select ID, NAME, AGE from USER where 1=1 and age > 10");
        List users = this.jdbcTemplate.query(sqlBuilder.toString(), (RowMapper)new RowMapper<User>(){

            public User mapRow(ResultSet rs, int rowNum) throws SQLException {
                User u = new User();
                u.setId(rs.getString("ID"));
                u.setName(rs.getString("NAME"));
                u.setAge(rs.getInt("AGE"));
                return u;
            }
        });
        String json = JSONBuilderProvider.simplest().toJson((Object)users);
        System.out.println(json);
        return request.getResult();
    }

    @GetMapping(value={"/_useSpringJdbc_pSetter_rExecutor"})
    public PagingResult list__useSpringJdbc_pSetter_rExecutor(@RequestParam(name="pageNo", required=false) Integer pageNo, @RequestParam(name="pageSize", required=false) Integer pageSize, @RequestParam(name="sort", required=false) String sort) {
        User queryCondtion = new User();
        queryCondtion.setAge(10);
        PagingRequest request = new PagingRequest().limit(pageNo == null ? 1 : pageNo, pageSize == null ? -1 : pageSize).setOrderBy(SqlStyleOrderByBuilder.DEFAULT.build(sort));
        PagingRequestContextHolder.getContext().setPagingRequest(request);
        StringBuilder sqlBuilder = new StringBuilder("select ID, NAME, AGE from USER where 1=1 and age > ?");
        List users = (List)this.jdbcTemplate.query(sqlBuilder.toString(), new PreparedStatementSetter(){

            public void setValues(PreparedStatement ps) throws SQLException {
                ps.setInt(1, 10);
            }
        }, (ResultSetExtractor)new ResultSetExtractor<List<User>>(){

            public List<User> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<User> users = new ArrayList<User>();
                while (rs.next()) {
                    User u = new User();
                    u.setId(rs.getString("ID"));
                    u.setName(rs.getString("NAME"));
                    u.setAge(rs.getInt("AGE"));
                    users.add(u);
                }
                return users;
            }
        });
        String json = JSONBuilderProvider.simplest().toJson((Object)request.getResult());
        System.out.println(json);
        return request.getResult();
    }

    @GetMapping(value={"/{id}"})
    public User getById(@RequestParam(value="id") String id) {
        return this.userDao.selectById(id);
    }
}

