/*
 * Decompiled with CFR 0.152.
 */
package com.jn.sqlhelper.jsqlparser.expression;

import com.jn.langx.annotation.Singleton;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.iter.IteratorIterable;
import com.jn.langx.util.function.Consumer;
import com.jn.sqlhelper.dialect.expression.SQLExpression;
import com.jn.sqlhelper.jsqlparser.expression.ExpressionConverter;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.sf.jsqlparser.expression.Expression;

@Singleton
public class ExpressionConverterRegistry {
    private static final ExpressionConverterRegistry instance = new ExpressionConverterRegistry();
    private Map<Class<? extends SQLExpression>, ExpressionConverter> standardExpressionConverterMap = new HashMap<Class<? extends SQLExpression>, ExpressionConverter>();
    private Map<Class<? extends Expression>, ExpressionConverter> jsqlparserExpressionConverterMap = new HashMap<Class<? extends Expression>, ExpressionConverter>();

    private ExpressionConverterRegistry() {
        this.registryBuiltins();
    }

    public static ExpressionConverterRegistry getInstance() {
        return instance;
    }

    public void registry(ExpressionConverter converter) {
        Class standardExpressionClass = converter.getStandardExpressionClass();
        Class jSqlParserExpressionClass = converter.getJSqlParserExpressionClass();
        Preconditions.checkNotNull(standardExpressionClass);
        Preconditions.checkNotNull(jSqlParserExpressionClass);
        this.standardExpressionConverterMap.put(standardExpressionClass, converter);
        this.jsqlparserExpressionConverterMap.put(jSqlParserExpressionClass, converter);
    }

    private void registryBuiltins() {
        ServiceLoader<ExpressionConverter> loader = ServiceLoader.load(ExpressionConverter.class);
        Collects.forEach((Iterable)new IteratorIterable(loader.iterator()), (Consumer)new Consumer<ExpressionConverter>(){

            public void accept(ExpressionConverter converter) {
                ExpressionConverterRegistry.this.registry(converter);
            }
        });
    }

    public ExpressionConverter getExpressionConverterByStandardExpressionClass(Class<? extends SQLExpression> clazz) {
        return this.standardExpressionConverterMap.get(clazz);
    }

    public ExpressionConverter getExpressionConverterByJSqlParserExpressionClass(Class<? extends Expression> clazz) {
        return this.jsqlparserExpressionConverterMap.get(clazz);
    }
}

