/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.enums;

import com.github.fartherp.framework.database.mybatis.plugin.search.exception.SearchException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SearchOperator {
    eq("\u7b49\u4e8e", "="),
    ne("\u4e0d\u7b49\u4e8e", "!="),
    gt("\u5927\u4e8e", ">"),
    gte("\u5927\u4e8e\u7b49\u4e8e", ">="),
    lt("\u5c0f\u4e8e", "<"),
    lte("\u5c0f\u4e8e\u7b49\u4e8e", "<="),
    prefixLike("\u524d\u7f00\u6a21\u7cca\u5339\u914d", "like"),
    prefixNotLike("\u524d\u7f00\u6a21\u7cca\u4e0d\u5339\u914d", "not like"),
    suffixLike("\u540e\u7f00\u6a21\u7cca\u5339\u914d", "like"),
    suffixNotLike("\u540e\u7f00\u6a21\u7cca\u4e0d\u5339\u914d", "not like"),
    like("\u6a21\u7cca\u5339\u914d", "like"),
    notLike("\u4e0d\u5339\u914d", "not like"),
    isNull("\u7a7a", "is null"),
    isNotNull("\u975e\u7a7a", "is not null"),
    in("\u5305\u542b", "in"),
    notIn("\u4e0d\u5305\u542b", "not in"),
    custom("\u81ea\u5b9a\u4e49\u9ed8\u8ba4\u7684", null);

    private String info;
    private String symbol;

    private SearchOperator(String info, String symbol) {
        this.info = info;
        this.symbol = symbol;
    }

    public String getInfo() {
        return this.info;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public static String toStringAllOperator() {
        return Arrays.toString((Object[])SearchOperator.values());
    }

    public static boolean isAllowBlankValue(SearchOperator operator) {
        return operator == isNotNull || operator == isNull;
    }

    public static SearchOperator valueBySymbol(String symbol) throws SearchException {
        symbol = SearchOperator.formatSymbol(symbol);
        for (SearchOperator operator : SearchOperator.values()) {
            if (!operator.getSymbol().equals(symbol)) continue;
            return operator;
        }
        throw new SearchException("SearchOperator not method search operator symbol : " + symbol);
    }

    private static String formatSymbol(String symbol) {
        if (StringUtils.isBlank((String)symbol)) {
            return symbol;
        }
        return symbol.trim().toLowerCase().replace("  ", " ");
    }
}

