/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.utils;

import com.github.fartherp.framework.core.bean.ServiceLocator;
import com.github.fartherp.framework.database.mybatis.plugin.search.enums.SearchOperator;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.InvalidSearchPropertyException;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.InvalidSearchValueException;
import com.github.fartherp.framework.database.mybatis.plugin.search.exception.SearchException;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.CustomCondition;
import com.github.fartherp.framework.database.mybatis.plugin.search.filter.SearchFilter;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Searchable;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchableConvertUtils {
    private static volatile ConversionService conversionService;

    public static void setConversionService(ConversionService conversionService) {
        SearchableConvertUtils.conversionService = conversionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConversionService getConversionService() {
        if (conversionService != null) return conversionService;
        Class<SearchableConvertUtils> clazz = SearchableConvertUtils.class;
        synchronized (SearchableConvertUtils.class) {
            if (conversionService != null) return conversionService;
            try {
                conversionService = (ConversionService)ServiceLocator.getBean(ConversionService.class);
            }
            catch (Exception e) {
                throw new SearchException("conversionService is null, search param convert must use conversionService. please see [com.sishuok.es.common.entity.search.utils.SearchableConvertUtils#setConversionService]");
            }
            return conversionService;
        }
    }

    public static <T> void convertSearchValueToEntityValue(Searchable search, Class<T> entityClass) {
        if (search.isConverted()) {
            return;
        }
        Collection<SearchFilter> searchFilters = search.getSearchFilters();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(entityClass);
        beanWrapper.setAutoGrowNestedPaths(true);
        beanWrapper.setConversionService(SearchableConvertUtils.getConversionService());
        for (SearchFilter searchFilter : searchFilters) {
            SearchableConvertUtils.convertSearchValueToEntityValue(beanWrapper, searchFilter);
        }
    }

    private static void convertSearchValueToEntityValue(BeanWrapperImpl beanWrapper, SearchFilter searchFilter) {
        if (searchFilter instanceof CustomCondition) {
            CustomCondition customCondition = (CustomCondition)searchFilter;
            SearchableConvertUtils.convert(beanWrapper, customCondition);
            if (((CustomCondition)searchFilter).hasOrFilters()) {
                for (SearchFilter searchFilter2 : ((CustomCondition)searchFilter).getOrFilters()) {
                    SearchableConvertUtils.convertSearchValueToEntityValue(beanWrapper, searchFilter2);
                }
            }
            if (((CustomCondition)searchFilter).hasAndFilters()) {
                for (SearchFilter searchFilter3 : ((CustomCondition)searchFilter).getAndFilters()) {
                    SearchableConvertUtils.convertSearchValueToEntityValue(beanWrapper, searchFilter3);
                }
            }
            return;
        }
    }

    private static void convert(BeanWrapperImpl beanWrapper, CustomCondition customCondition) {
        boolean isArray;
        String searchProperty = customCondition.getSearchProperty();
        if (customCondition.getOperator() == SearchOperator.custom) {
            return;
        }
        if (customCondition.isUnaryFilter()) {
            return;
        }
        String entityProperty = customCondition.getEntityProperty();
        Object value = customCondition.getValue();
        ArrayList<Object> newValue = null;
        boolean isCollection = value instanceof Collection;
        boolean bl = isArray = value != null && value.getClass().isArray();
        if (isCollection || isArray) {
            ArrayList<Object> list;
            if (isCollection) {
                list = new ArrayList<Object>();
                list.addAll((Collection)value);
            } else {
                list = CollectionUtils.arrayToList((Object)value);
            }
            int length = list.size();
            for (int i = 0; i < length; ++i) {
                list.set(i, SearchableConvertUtils.getConvertedValue(beanWrapper, searchProperty, entityProperty, list.get(i)));
            }
            newValue = list;
        } else {
            newValue = SearchableConvertUtils.getConvertedValue(beanWrapper, searchProperty, entityProperty, value);
        }
        customCondition.setValue(newValue);
    }

    private static Object getConvertedValue(BeanWrapperImpl beanWrapper, String searchProperty, String entityProperty, Object value) {
        Object newValue;
        try {
            beanWrapper.setPropertyValue(entityProperty, value);
            newValue = beanWrapper.getPropertyValue(entityProperty);
        }
        catch (InvalidPropertyException e) {
            throw new InvalidSearchPropertyException(searchProperty, entityProperty, e);
        }
        catch (Exception e) {
            throw new InvalidSearchValueException(searchProperty, entityProperty, value, e);
        }
        return newValue;
    }
}

