/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.page;

import com.github.fartherp.framework.database.mybatis.plugin.page.BaseInterceptor;
import com.github.fartherp.framework.database.mybatis.plugin.page.Pagination;
import com.github.fartherp.framework.database.mybatis.plugin.page.SqlHelper;
import java.sql.Connection;
import java.util.Map;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class PaginationInterceptor
extends BaseInterceptor {
    public static final String MAP_PAGE_FIELD = Pagination.MAP_PAGE_FIELD;
    public static final String PAGE = ".*findPage*.*";

    public PaginationInterceptor() {
        this.sqlPattern = PAGE;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (mappedStatement.getId().matches(this.sqlPattern)) {
            Object parameter = invocation.getArgs()[1];
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            String originalSql = boundSql.getSql().trim();
            Object parameterObject = boundSql.getParameterObject();
            Pagination page = null;
            if (parameterObject != null) {
                page = this.convertParameter(parameterObject, page);
            }
            if (page != null) {
                int totPage = page.getTotal();
                if (totPage <= 0) {
                    Connection connection = mappedStatement.getConfiguration().getEnvironment().getDataSource().getConnection();
                    totPage = SqlHelper.getCount(originalSql, connection, mappedStatement, parameterObject, boundSql);
                }
                page.init(totPage, page.getLimit(), page.getCurrentPage());
                String pageSql = SqlHelper.generatePageSql(originalSql, page, this.dialect);
                this.log.info((Object)("\u5206\u9875SQL:" + pageSql));
                invocation.getArgs()[2] = new RowBounds(0, Integer.MAX_VALUE);
                BoundSql newBoundSql = SqlHelper.createNewBoundSql(mappedStatement, boundSql.getParameterObject(), boundSql, pageSql);
                MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, new BaseInterceptor.BoundSqlSqlSource(newBoundSql));
                invocation.getArgs()[0] = newMs;
            }
        }
        return invocation.proceed();
    }

    private Pagination convertParameter(Object parameterObject, Pagination pagination) {
        if (parameterObject instanceof Pagination) {
            pagination = (Pagination)parameterObject;
        } else if (parameterObject instanceof Map) {
            Map parameterMap = (Map)parameterObject;
            pagination = (Pagination)parameterMap.get(MAP_PAGE_FIELD);
            if (pagination == null) {
                throw new PersistenceException("\u5206\u9875\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            }
            parameterMap.put(MAP_PAGE_FIELD, pagination);
        }
        return pagination;
    }
}

