/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.page;

import com.github.fartherp.framework.common.util.ReflectUtil;
import com.github.fartherp.framework.database.mybatis.plugin.page.Pagination;
import com.github.fartherp.framework.database.mybatis.plugin.page.dialect.Dialect;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.executor.ExecutorException;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.property.PropertyTokenizer;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlHelper {
    protected static Log log = LogFactory.getLog(SqlHelper.class);

    public static void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        ErrorContext.instance().activity("setting parameters").object(mappedStatement.getParameterMap().getId());
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            Configuration configuration = mappedStatement.getConfiguration();
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            MetaObject metaObject = parameterObject == null ? null : configuration.newMetaObject(parameterObject);
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                PropertyTokenizer prop = new PropertyTokenizer(propertyName);
                if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (propertyName.startsWith("__frch_") && boundSql.hasAdditionalParameter(prop.getName())) {
                    value = boundSql.getAdditionalParameter(prop.getName());
                    if (value != null) {
                        value = configuration.newMetaObject(value).getValue(propertyName.substring(prop.getName().length()));
                    }
                } else {
                    value = metaObject == null ? null : metaObject.getValue(propertyName);
                }
                TypeHandler typeHandler = parameterMapping.getTypeHandler();
                if (typeHandler == null) {
                    throw new ExecutorException("There was no TypeHandler found for parameter " + propertyName + " of statement " + mappedStatement.getId());
                }
                typeHandler.setParameter(ps, i + 1, value, parameterMapping.getJdbcType());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(String sql, Connection connection, MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql) {
        String countSql = "select count(1) from (" + SqlHelper.excludeOrderBy(sql) + ") as tmp_count";
        log.debug((Object)("Pagination TotalCount SQL: " + countSql));
        Statement countStmt = null;
        ResultSet rs = null;
        try {
            connection.setReadOnly(true);
            connection.setAutoCommit(true);
            countStmt = connection.prepareStatement(countSql);
            BoundSql countBS = SqlHelper.createNewBoundSql(mappedStatement, parameterObject, boundSql, countSql);
            SqlHelper.setParameters((PreparedStatement)countStmt, mappedStatement, countBS, parameterObject);
            rs = countStmt.executeQuery();
            int count = 0;
            if (rs.next()) {
                count = rs.getInt(1);
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)"", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (countStmt != null) {
                    countStmt.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public static BoundSql createNewBoundSql(MappedStatement mappedStatement, Object parameterObject, BoundSql boundSql, String newSql) {
        BoundSql countBS = new BoundSql(mappedStatement.getConfiguration(), newSql, boundSql.getParameterMappings(), parameterObject);
        SqlHelper.setValue(countBS, boundSql, "metaParameters", "additionalParameters");
        return countBS;
    }

    private static void setValue(BoundSql countBS, BoundSql boundSql, String ... properties) {
        for (String p : properties) {
            Field metaParamsField = ReflectUtil.getFieldByFieldName((Object)boundSql, (String)p);
            Object mo = ReflectUtil.getValueByFieldName((Object)boundSql, (Field)metaParamsField);
            ReflectUtil.setValueByFieldName((Object)countBS, (String)p, (Object)mo);
        }
    }

    private static String excludeOrderBy(String sql) {
        if (StringUtils.isBlank((CharSequence)sql)) {
            return sql;
        }
        Pattern p = Pattern.compile("order\\s*by[\\w|\\W|\\s|\\S]*", 2);
        Matcher m = p.matcher(sql);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, "");
        }
        if (sb.length() == 0) {
            return sql;
        }
        return sb.toString();
    }

    public static String generatePageSql(String sql, Pagination<Serializable> page, Dialect dialect) {
        if (dialect.supportsLimit()) {
            int pageSize = page.getLimit();
            int index = (page.getCurrentPage() - 1) * pageSize;
            int start = index < 0 ? 0 : index;
            return dialect.getLimitString(sql, start, pageSize);
        }
        return sql;
    }
}

