/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.page;

import com.github.fartherp.framework.database.mybatis.plugin.page.dialect.Dialect;
import com.github.fartherp.framework.database.mybatis.plugin.page.dialect.DialectType;
import java.io.Serializable;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Plugin;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;

public abstract class BaseInterceptor
implements Interceptor,
Serializable {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Dialect dialect = DialectType.getDialect("mysql");
    protected String dialectClass;
    protected String sqlPattern;

    public MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        Object[] keyProperties = ms.getKeyProperties();
        builder.keyProperty(StringUtils.join((Object[])keyProperties, (char)','));
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.cache(ms.getCache());
        return builder.build();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        if (properties.keySet().isEmpty()) {
            return;
        }
        BeanWrapper beanWrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)this);
        MutablePropertyValues mutablePropertyValues = new MutablePropertyValues();
        for (Object o : properties.keySet()) {
            PropertyValue propertyValue = new PropertyValue(o.toString(), properties.get(o));
            mutablePropertyValues.addPropertyValue(propertyValue);
        }
        beanWrapper.setPropertyValues((PropertyValues)mutablePropertyValues);
        if (StringUtils.isNotBlank((CharSequence)this.dialectClass)) {
            this.dialect = DialectType.getDialect(this.dialectClass);
            if (this.dialect == null) {
                throw new RuntimeException("\u65b9\u8a00\u5b9e\u4f8b\u9519\u8bef");
            }
        }
    }

    public void setDialectClass(String dialectClass) {
        this.dialectClass = dialectClass;
    }

    public void setSqlPattern(String sqlPattern) {
        this.sqlPattern = sqlPattern;
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

