/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.page;

import com.github.fartherp.framework.database.mybatis.plugin.page.Pagination;
import java.io.Serializable;
import java.util.List;

public class BasePagination<T extends Serializable>
implements Pagination<T> {
    public static final int DEFAULT_PAGE_SIZE = 10;
    public static final int DEFAULT_PAGE_NUM = 1;
    public int firstPage = 1;
    public static final int DEFAULT_MAX_PAGE_INDEX_NUMBER = 9;
    private transient int maxPageIndexNumber = 9;
    protected transient int[] pageNumberList = new int[0];
    protected int total;
    protected int limit = 10;
    protected transient int totalPage;
    protected transient int currentPage;
    protected transient int nextPage;
    protected transient int previousPage;
    protected transient boolean hasNext = false;
    protected transient boolean hasPrevious = false;
    protected List<T> rows;

    public BasePagination() {
        this(0);
    }

    public BasePagination(int total) {
        this(total, 1);
    }

    public BasePagination(int total, int currentPage) {
        this(total, 10, currentPage);
    }

    public BasePagination(int total, int limit, int currentPage) {
        this(total, limit, currentPage, 9);
    }

    public BasePagination(int total, int limit, int currentPage, int maxPageIndexNumber) {
        this.maxPageIndexNumber = maxPageIndexNumber;
        this.init(total, limit, currentPage);
    }

    public BasePagination(List<T> content, int total) {
        this(content, total, 1);
    }

    public BasePagination(List<T> content, int total, int currentPage) {
        this(total, 10, currentPage);
        this.setRows(content);
    }

    @Override
    public void init(int total, int limit, int currentPage) {
        this.total = total;
        this.limit = limit;
        this.currentPage = currentPage;
        this.calculatePage();
    }

    private void calculatePage() {
        this.totalPage = this.total % this.limit == 0 ? this.total / this.limit : this.total / this.limit + 1;
        this.hasPrevious = this.currentPage - 1 > 0;
        boolean bl = this.hasNext = this.currentPage < this.totalPage;
        if (this.hasPrevious) {
            this.previousPage = this.currentPage - 1;
        }
        if (this.hasNext) {
            this.nextPage = this.currentPage + 1;
        }
    }

    @Override
    public List<T> getRows() {
        return this.rows;
    }

    @Override
    public void setRows(List<T> rows) {
        this.rows = rows;
    }

    @Override
    public int getTotal() {
        return this.total;
    }

    @Override
    public int getLimit() {
        return this.limit;
    }

    @Override
    public int getTotalPage() {
        return this.totalPage;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean isHasNext() {
        return this.hasNext;
    }

    public void setHasNext(boolean hasNext) {
        this.hasNext = hasNext;
    }

    @Override
    public int getNextPage() {
        return this.nextPage;
    }

    @Override
    public boolean isHasPrevious() {
        return this.hasPrevious;
    }

    @Override
    public int getPreviousPage() {
        return this.previousPage;
    }

    @Override
    public int getMaxPageIndexNumber() {
        return this.maxPageIndexNumber;
    }

    @Override
    public void setMaxPageIndexNumber(int maxPageIndexNumber) {
        this.maxPageIndexNumber = maxPageIndexNumber;
    }

    @Override
    public void setTotal(int total) {
        this.total = total;
    }

    @Override
    public void setLimit(int limit) {
        this.limit = limit;
    }

    @Override
    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(int firstPage) {
        this.firstPage = firstPage;
    }

    @Override
    public int[] getPageNumberList() {
        if (this.totalPage > this.maxPageIndexNumber) {
            this.pageNumberList = new int[this.maxPageIndexNumber];
            int offset = (this.maxPageIndexNumber - 4) / 2;
            if (this.currentPage - offset <= 3) {
                for (int index = 0; index < this.maxPageIndexNumber - 2; ++index) {
                    this.pageNumberList[index] = index + 1;
                }
            } else if (this.currentPage + offset >= this.totalPage - 2) {
                int start = this.totalPage;
                for (int index = this.maxPageIndexNumber - 1; index > 1; --index) {
                    this.pageNumberList[index] = start--;
                }
            } else {
                int start = this.currentPage - offset;
                for (int index = 2; index < this.maxPageIndexNumber - 2; ++index) {
                    this.pageNumberList[index] = start++;
                }
            }
            this.pageNumberList[0] = 1;
            this.pageNumberList[this.maxPageIndexNumber - 1] = this.totalPage;
        } else {
            this.pageNumberList = new int[this.totalPage];
            for (int index = 0; index <= this.totalPage - 1; ++index) {
                this.pageNumberList[index] = index + 1;
            }
        }
        return this.pageNumberList;
    }

    public String toString() {
        String contentType = "UNKNOWN";
        if (this.rows.size() > 0) {
            contentType = ((Serializable)this.rows.get(0)).getClass().getName();
        }
        return String.format("Page %s of %d containing %s instances", this.getLimit(), this.getTotal(), contentType);
    }
}

