/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.page;

import com.github.fartherp.framework.database.mybatis.plugin.page.BasePagination;
import com.github.fartherp.framework.database.mybatis.plugin.page.Pagination;
import java.io.Serializable;

public class PageRequest
extends BasePagination
implements Pagination,
Serializable {
    private static long serialVersionUID = 8280485938848398236L;

    public PageRequest(int page, int limit) {
        this.setCurrentPage(page);
        this.setLimit(limit);
    }

    public int getPageSize() {
        return this.totalPage;
    }

    public int getPageNumber() {
        return this.currentPage;
    }

    public int getOffset() {
        return this.currentPage * this.limit;
    }

    public Pagination previousOrFirst() {
        return this.hasPrevious ? new PageRequest(this.currentPage - 1, this.limit) : this;
    }

    public Pagination first() {
        return new PageRequest(0, this.limit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PageRequest)) {
            return false;
        }
        PageRequest that = (PageRequest)obj;
        boolean pageEqual = this.currentPage == that.currentPage;
        boolean sizeEqual = this.limit == that.limit;
        return pageEqual && sizeEqual;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.currentPage;
        result = 31 * result + this.limit;
        result = 31 * result;
        return result;
    }

    @Override
    public String toString() {
        return String.format("Page request [number: %d, limit %d, sort: %s]", this.currentPage, this.limit);
    }
}

