/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.page.dialect;

import com.github.fartherp.framework.database.mybatis.plugin.page.dialect.Dialect;
import com.github.fartherp.framework.database.mybatis.plugin.page.dialect.MySQLDialect;
import org.apache.commons.lang3.StringUtils;

public enum DialectType {
    MYSQL("mysql", MySQLDialect.class.getName()),
    ORACLE("oracle", ""),
    SQL_SERVER("microsoft sql server", "");

    private String name;
    private String className;

    private DialectType(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public static Dialect getDialect(String name) {
        DialectType[] types;
        for (DialectType type : types = DialectType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)type.getName(), (CharSequence)name)) continue;
            try {
                Class<?> forName = Class.forName(type.getClassName());
                return (Dialect)forName.newInstance();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

