/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search;

import com.github.fartherp.framework.database.mybatis.plugin.page.BaseInterceptor;
import com.github.fartherp.framework.database.mybatis.plugin.page.SqlHelper;
import com.github.fartherp.framework.database.mybatis.plugin.search.SqlFacade;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Searchable;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SearchableInterceptor
extends BaseInterceptor {
    public static final String SEARCHABLE = ".*BySearchable*.*";

    public SearchableInterceptor() {
        this.sqlPattern = SEARCHABLE;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        if (mappedStatement.getId().matches(this.sqlPattern)) {
            Object parameter = invocation.getArgs()[1];
            if (!Searchable.class.isAssignableFrom(parameter.getClass())) {
                return invocation.proceed();
            }
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            String originalSql = boundSql.getSql().trim();
            String realSql = SqlFacade.generateRealSql(originalSql, (Searchable)parameter, this.dialect);
            this.log.info((Object)("\u6700\u7ec8 \u7684sql\u4e3a:" + realSql));
            invocation.getArgs()[2] = new RowBounds(0, Integer.MAX_VALUE);
            BoundSql newBoundSql = SqlHelper.createNewBoundSql(mappedStatement, boundSql.getParameterObject(), boundSql, realSql);
            MappedStatement newMs = this.copyFromMappedStatement(mappedStatement, new BaseInterceptor.BoundSqlSqlSource(newBoundSql));
            invocation.getArgs()[0] = newMs;
        }
        return invocation.proceed();
    }
}

