/*
 * Decompiled with CFR 0.152.
 */
package com.github.fartherp.framework.database.mybatis.plugin.search.resolver;

import com.github.fartherp.framework.database.mybatis.plugin.page.dialect.Dialect;
import com.github.fartherp.framework.database.mybatis.plugin.search.resolver.SqlResolver;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Param;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Searchable;
import com.github.fartherp.framework.database.mybatis.plugin.search.vo.Sort;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractSqlResolverInter
implements SqlResolver {
    protected Param param = new Param();

    public AbstractSqlResolverInter(String alias) {
        this.param.alias = alias;
        this.param.aliasWithDot = !StringUtils.isEmpty((Object)alias) ? alias + "." : "";
    }

    public Param getParam() {
        return this.param;
    }

    public String getAliasWithDot() {
        return this.param.aliasWithDot;
    }

    @Override
    public void prepareOrder(StringBuilder ql, Searchable search) {
        if (search.hashSort()) {
            ql.append(" order by ");
            for (Sort.Order order : search.sort) {
                ql.append(String.format("%s%s %s, ", this.getAliasWithDot(), order.getProperty(), order.getDirection().name().toLowerCase()));
            }
            ql.delete(ql.length() - 2, ql.length());
        }
    }

    @Override
    public void setPageable(StringBuilder sql, Searchable searchable, Dialect dialect) {
        if (dialect.supportsLimit() && searchable.getPage() != null && !ObjectUtils.equals((Object)searchable.getPage(), (Object)ObjectUtils.NULL)) {
            int pageSize = searchable.getPage().getLimit();
            int index = (searchable.getPage().getCurrentPage() - 1) * pageSize;
            int start = index < 0 ? 0 : index;
            dialect.getLimitString(sql, start, pageSize);
        }
    }
}

